/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.loader;

import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;

public class SegmentDirectoryLoaderContext {
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final String _instanceId;
    private final String _segmentName;
    private final String _segmentCrc;
    private final PinotConfiguration _segmentDirectoryConfigs;

    private SegmentDirectoryLoaderContext(TableConfig tableConfig, Schema schema, String instanceId, String segmentName, String segmentCrc, PinotConfiguration segmentDirectoryConfigs) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._instanceId = instanceId;
        this._segmentName = segmentName;
        this._segmentCrc = segmentCrc;
        this._segmentDirectoryConfigs = segmentDirectoryConfigs;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public String getSegmentCrc() {
        return this._segmentCrc;
    }

    public PinotConfiguration getSegmentDirectoryConfigs() {
        return this._segmentDirectoryConfigs;
    }

    public static class Builder {
        private TableConfig _tableConfig;
        private Schema _schema;
        private String _instanceId;
        private String _segmentName;
        private String _segmentCrc;
        private PinotConfiguration _segmentDirectoryConfigs;

        public Builder setTableConfig(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this._instanceId = instanceId;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder setSegmentCrc(String segmentCrc) {
            this._segmentCrc = segmentCrc;
            return this;
        }

        public Builder setSegmentDirectoryConfigs(PinotConfiguration segmentDirectoryConfigs) {
            this._segmentDirectoryConfigs = segmentDirectoryConfigs;
            return this;
        }

        public SegmentDirectoryLoaderContext build() {
            return new SegmentDirectoryLoaderContext(this._tableConfig, this._schema, this._instanceId, this._segmentName, this._segmentCrc, this._segmentDirectoryConfigs);
        }
    }
}

