/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlOperandCountRanges;

public class HiveExplodeOperator
extends SqlUnnestOperator {
    public static final HiveExplodeOperator EXPLODE = new HiveExplodeOperator();
    public static final String ARRAY_ELEMENT_COLUMN_NAME = "col";

    public HiveExplodeOperator() {
        super(false);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType operandType = callBinding.getOperandType(0);
        return operandType instanceof ArraySqlType || operandType instanceof MapSqlType;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)1);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType operandType = opBinding.getOperandType(0);
        RelDataTypeFactory.FieldInfoBuilder builder = opBinding.getTypeFactory().builder();
        if (operandType instanceof ArraySqlType) {
            builder.add(ARRAY_ELEMENT_COLUMN_NAME, operandType.getComponentType());
        } else {
            builder.add("KEY", operandType.getKeyType());
            builder.add("VALUE", operandType.getValueType());
        }
        return builder.build();
    }
}

