/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.parsetree;

import com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.Iterables;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.common.functions.FunctionFieldReferenceOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveExplodeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionResolver;
import com.linkedin.coral.hive.hive2rel.functions.HiveJsonTupleOperator;
import com.linkedin.coral.hive.hive2rel.functions.HivePosExplodeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveRLikeOperator;
import com.linkedin.coral.hive.hive2rel.functions.StaticHiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.functions.VersionedSqlUserDefinedFunction;
import com.linkedin.coral.hive.hive2rel.parsetree.AbstractASTVisitor;
import com.linkedin.coral.hive.hive2rel.parsetree.UnhandledASTTokenException;
import com.linkedin.coral.hive.hive2rel.parsetree.UnsupportedASTException;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ASTNode;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.CoralParseDriver;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.Node;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ParseDriver;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLateralOperator;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.metastore.api.Table;

public class ParseTreeBuilder
extends AbstractASTVisitor<SqlNode, ParseContext> {
    private final HiveFunctionResolver functionResolver;

    public ParseTreeBuilder(HiveFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    public SqlNode processSql(String sql) {
        return this.process(sql, null);
    }

    public SqlNode process(String sql, @Nullable Table hiveView) {
        CoralParseDriver pd = new CoralParseDriver();
        try {
            ASTNode root = ((ParseDriver)pd).parse(sql);
            return this.processAST(root, hiveView);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private SqlNode processAST(ASTNode node, @Nullable Table hiveView) {
        ParseContext ctx = new ParseContext(hiveView);
        return (SqlNode)this.visit(node, ctx);
    }

    @Override
    protected SqlNode visitTabAlias(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes.size() == 1 ? 1 : 0) != 0);
        return (SqlNode)sqlNodes.get(0);
    }

    @Override
    protected SqlNode visitLateralView(ASTNode node, ParseContext ctx) {
        return this.visitLateralViewInternal(node, ctx, false);
    }

    @Override
    protected SqlNode visitLateralViewOuter(ASTNode node, ParseContext ctx) {
        return this.visitLateralViewInternal(node, ctx, true);
    }

    private SqlNode visitLateralViewInternal(ASTNode node, ParseContext ctx, boolean isOuter) {
        List<SqlNode> sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes.size() == 2 && sqlNodes.get(0) instanceof SqlNodeList ? 1 : 0) != 0);
        SqlNode rightNode = (SqlNode)Iterables.getOnlyElement((Iterable)((SqlNodeList)sqlNodes.get(0)));
        if (!(rightNode instanceof SqlCall) || !(((SqlCall)rightNode).getOperator() instanceof SqlAsOperator)) {
            throw new UnsupportedOperationException(String.format("Unsupported LATERAL VIEW without AS: %s", rightNode));
        }
        SqlCall aliasCall = (SqlCall)rightNode;
        List aliasOperands = aliasCall.getOperandList();
        Preconditions.checkState((boolean)(aliasOperands.get(0) instanceof SqlCall));
        SqlCall tableFunctionCall = (SqlCall)aliasOperands.get(0);
        if (tableFunctionCall.getOperator() instanceof HiveExplodeOperator || tableFunctionCall.getOperator() instanceof HivePosExplodeOperator) {
            return this.visitLateralViewExplode(sqlNodes, aliasOperands, tableFunctionCall, isOuter);
        }
        if (tableFunctionCall.getOperator() instanceof HiveJsonTupleOperator) {
            return this.visitLateralViewJsonTuple(sqlNodes, aliasOperands, tableFunctionCall);
        }
        if (tableFunctionCall.getOperator() instanceof VersionedSqlUserDefinedFunction) {
            return this.visitLateralViewUDTF(sqlNodes, aliasOperands, tableFunctionCall);
        }
        throw new UnsupportedOperationException(String.format("Unsupported LATERAL VIEW operator: %s", tableFunctionCall));
    }

    private SqlNode visitLateralViewUDTF(List<SqlNode> sqlNodes, List<SqlNode> aliasOperands, SqlCall tableFunctionCall) {
        SqlCall lateralCall = SqlStdOperatorTable.LATERAL.createCall(SqlParserPos.ZERO, new SqlNode[]{new SqlLateralOperator(SqlKind.COLLECTION_TABLE).createCall(SqlParserPos.ZERO, new SqlNode[]{tableFunctionCall})});
        String functionName = tableFunctionCall.getOperator().getName();
        ImmutableList fieldNames = StaticHiveFunctionRegistry.UDTF_RETURN_FIELD_NAME_MAP.getOrDefault(functionName, null);
        if (fieldNames == null) {
            throw new RuntimeException("User defined table function " + functionName + " is not registered.");
        }
        ArrayList<Object> asOperands = new ArrayList<Object>();
        asOperands.add(lateralCall);
        asOperands.add(aliasOperands.get(1));
        fieldNames.forEach(name -> asOperands.add(new SqlIdentifier(name, SqlParserPos.ZERO)));
        SqlCall aliasCall = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, asOperands);
        return new SqlJoin(SqlParserPos.ZERO, sqlNodes.get(1), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), (SqlNode)aliasCall, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
    }

    private SqlNode visitLateralViewExplode(List<SqlNode> sqlNodes, List<SqlNode> aliasOperands, SqlCall tableFunctionCall, boolean isOuter) {
        int operandCount = aliasOperands.size();
        Preconditions.checkState((operandCount == 2 || operandCount == 3 || operandCount == 4 ? 1 : 0) != 0, (Object)String.format("Unsupported LATERAL VIEW EXPLODE operand number: %d", operandCount));
        SqlCall unnestCall = tableFunctionCall;
        SqlNode unnestOperand = unnestCall.operand(0);
        SqlOperator operator = unnestCall.getOperator();
        if (isOuter) {
            Preconditions.checkState((operandCount > 2 ? 1 : 0) != 0, (Object)"LATERAL VIEW OUTER EXPLODE without column aliases is not supported. Add 'AS col' or 'AS key, value' to fix it");
            SqlCall operandIsNull = SqlStdOperatorTable.IS_NOT_NULL.createCall(SqlParserPos.ZERO, new SqlNode[]{unnestOperand});
            SqlCall emptyArray = SqlStdOperatorTable.GREATER_THAN.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlStdOperatorTable.CARDINALITY.createCall(SqlParserPos.ZERO, new SqlNode[]{unnestOperand}), SqlLiteral.createExactNumeric((String)"0", (SqlParserPos)SqlParserPos.ZERO)});
            SqlCall ifCondition = SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, new SqlNode[]{operandIsNull, emptyArray});
            SqlCall arrayOrMapOfNull = operandCount == 3 || operator instanceof HivePosExplodeOperator ? SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO)}) : SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO), SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO)});
            Function hiveIfFunction = this.functionResolver.tryResolve("if", null, 1);
            unnestOperand = hiveIfFunction.createCall((SqlNode)SqlLiteral.createCharString((String)"if", (SqlParserPos)SqlParserPos.ZERO), (List)ImmutableList.of((Object)ifCondition, (Object)unnestOperand, (Object)arrayOrMapOfNull), null);
        }
        unnestCall = operator.createCall(SqlParserPos.ZERO, new SqlNode[]{unnestOperand});
        ArrayList<Object> asOperands = new ArrayList<Object>();
        asOperands.add(unnestCall);
        if (operator instanceof HivePosExplodeOperator && operandCount == 4) {
            asOperands.add(aliasOperands.get(1));
            asOperands.add(aliasOperands.get(3));
            asOperands.add(aliasOperands.get(2));
        } else {
            asOperands.addAll(aliasOperands.subList(1, aliasOperands.size()));
        }
        SqlCall as = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, asOperands);
        SqlCall lateralCall = SqlStdOperatorTable.LATERAL.createCall(SqlParserPos.ZERO, new SqlNode[]{as});
        return new SqlJoin(SqlParserPos.ZERO, sqlNodes.get(1), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), (SqlNode)lateralCall, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
    }

    private SqlNode visitLateralViewJsonTuple(List<SqlNode> sqlNodes, List<SqlNode> aliasOperands, SqlCall sqlCall) {
        Function getJsonObjectFunction = this.functionResolver.tryResolve("get_json_object", null, 2);
        Function ifFunction = this.functionResolver.tryResolve("if", null, 3);
        List jsonTupleOperands = sqlCall.getOperandList();
        SqlNode jsonInput = (SqlNode)jsonTupleOperands.get(0);
        ArrayList<SqlCall> projections = new ArrayList<SqlCall>();
        for (int jsonKeyPosition = 0; jsonKeyPosition < jsonTupleOperands.size() - 1; ++jsonKeyPosition) {
            SqlCall ifFunctionCall;
            SqlNode jsonKey = (SqlNode)jsonTupleOperands.get(1 + jsonKeyPosition);
            SqlNode keyAlias = aliasOperands.get(2 + jsonKeyPosition);
            SqlCall jsonPath = SqlStdOperatorTable.CONCAT.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlStdOperatorTable.CONCAT.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlLiteral.createCharString((String)"$[\"", (SqlParserPos)SqlParserPos.ZERO), jsonKey}), SqlLiteral.createCharString((String)"\"]", (SqlParserPos)SqlParserPos.ZERO)});
            SqlCall getJsonObjectCall = getJsonObjectFunction.createCall((SqlNode)SqlLiteral.createCharString((String)getJsonObjectFunction.getFunctionName(), (SqlParserPos)SqlParserPos.ZERO), (List)ImmutableList.of((Object)jsonInput, (Object)jsonPath), null);
            SqlCall castToString = SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{getJsonObjectCall, this.createBasicTypeSpec(SqlTypeName.VARCHAR)});
            SqlCall ifCondition = HiveRLikeOperator.RLIKE.createCall(SqlParserPos.ZERO, new SqlNode[]{jsonKey, SqlLiteral.createCharString((String)"^[^\\\"]*$", (SqlParserPos)SqlParserPos.ZERO)});
            SqlCall projection = ifFunctionCall = ifFunction.createCall((SqlNode)SqlLiteral.createCharString((String)ifFunction.getFunctionName(), (SqlParserPos)SqlParserPos.ZERO), (List)ImmutableList.of((Object)ifCondition, (Object)castToString, (Object)SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO)), null);
            projections.add(SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, new SqlNode[]{projection, keyAlias}));
        }
        SqlSelect select = new SqlSelect(SqlParserPos.ZERO, null, new SqlNodeList(projections, SqlParserPos.ZERO), null, null, null, null, null, null, null, null);
        SqlCall lateral = SqlStdOperatorTable.LATERAL.createCall(SqlParserPos.ZERO, new SqlNode[]{select});
        SqlCall lateralAlias = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, (List)ImmutableList.builder().add((Object)lateral).addAll(aliasOperands.subList(1, aliasOperands.size())).build());
        SqlJoin joinNode = new SqlJoin(SqlParserPos.ZERO, sqlNodes.get(1), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), (SqlNode)lateralAlias, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
        return joinNode;
    }

    @Override
    protected SqlNode visitLeftSemiJoin(ASTNode node, ParseContext ctx) {
        throw new RuntimeException(String.format("%s, %s, %s", node.getType(), node.getText(), node.dump()));
    }

    @Override
    protected SqlNode visitCrossJoin(ASTNode node, ParseContext ctx) {
        throw new RuntimeException(String.format("%s, %s, %s", node.getType(), node.getText(), node.dump()));
    }

    @Override
    protected SqlNode visitFullOuterJoin(ASTNode node, ParseContext ctx) {
        return this.processJoin(node, ctx, JoinType.FULL);
    }

    @Override
    protected SqlNode visitRightOuterJoin(ASTNode node, ParseContext ctx) {
        return this.processJoin(node, ctx, JoinType.RIGHT);
    }

    @Override
    protected SqlNode visitJoin(ASTNode node, ParseContext ctx) {
        return this.processJoin(node, ctx, JoinType.INNER);
    }

    @Override
    protected SqlNode visitLeftOuterJoin(ASTNode node, ParseContext ctx) {
        return this.processJoin(node, ctx, JoinType.LEFT);
    }

    private SqlNode processJoin(ASTNode node, ParseContext ctx, JoinType joinType) {
        JoinConditionType conditionType;
        List children = this.visitChildren(node, ctx);
        Preconditions.checkState((children.size() == 2 || children.size() == 3 ? 1 : 0) != 0);
        SqlNode condition = null;
        if (children.size() == 2) {
            conditionType = JoinConditionType.NONE;
        } else {
            conditionType = JoinConditionType.ON;
            condition = (SqlNode)children.get(2);
        }
        return new SqlJoin(SqlParserPos.ZERO, (SqlNode)children.get(0), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), joinType.symbol(SqlParserPos.ZERO), (SqlNode)children.get(1), conditionType.symbol(SqlParserPos.ZERO), condition);
    }

    @Override
    protected SqlNode visitFalse(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitTrue(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createBoolean((boolean)true, (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitNullToken(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitLimit(ASTNode node, ParseContext ctx) {
        ctx.fetch = (SqlNode)this.visitChildren(node, ctx).get(0);
        return ctx.fetch;
    }

    @Override
    protected SqlNode visitUnion(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.UNION_ALL, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitNumber(ASTNode node, ParseContext ctx) {
        String strval = node.getText();
        return SqlLiteral.createExactNumeric((String)strval, (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitAllColRef(ASTNode node, ParseContext ctx) {
        List children = this.visitChildren(node, ctx);
        ArrayList<String> names = new ArrayList<String>();
        if (children != null) {
            for (SqlNode child : children) {
                names.addAll((Collection<String>)((SqlIdentifier)child).names);
            }
        }
        names.add("*");
        List<SqlParserPos> sqlParserPos = Collections.nCopies(names.size(), SqlParserPos.ZERO);
        SqlIdentifier star = SqlIdentifier.star(names, (SqlParserPos)SqlParserPos.ZERO, sqlParserPos);
        return star;
    }

    @Override
    protected SqlNode visitHaving(ASTNode node, ParseContext ctx) {
        Preconditions.checkState((((ArrayList)node.getChildren()).size() == 1 ? 1 : 0) != 0);
        ctx.having = (SqlNode)this.visit((ASTNode)((ArrayList)node.getChildren()).get(0), ctx);
        return ctx.having;
    }

    @Override
    protected SqlNode visitWhere(ASTNode node, ParseContext ctx) {
        Preconditions.checkState((((ArrayList)node.getChildren()).size() == 1 ? 1 : 0) != 0);
        ctx.where = (SqlNode)this.visit((ASTNode)((ArrayList)node.getChildren()).get(0), ctx);
        return ctx.where;
    }

    @Override
    protected SqlNode visitSortColNameDesc(ASTNode node, ParseContext ctx) {
        return this.visitSortColName(node, ctx, true);
    }

    @Override
    protected SqlNode visitSortColNameAsc(ASTNode node, ParseContext ctx) {
        return this.visitSortColName(node, ctx, false);
    }

    private SqlNode visitSortColName(ASTNode node, ParseContext ctx, boolean descending) {
        List children = this.visitChildren(node, ctx);
        Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0);
        if (!descending) {
            return (SqlNode)children.get(0);
        }
        return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.DESC, new SqlNode[]{(SqlNode)children.get(0)}, SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitOrderBy(ASTNode node, ParseContext ctx) {
        List orderByCols = this.visitChildren(node, ctx);
        ctx.orderBy = new SqlNodeList(orderByCols, SqlParserPos.ZERO);
        return ctx.orderBy;
    }

    @Override
    protected SqlNode visitGroupBy(ASTNode node, ParseContext ctx) {
        List grpCols = this.visitChildren(node, ctx);
        ctx.grpBy = new SqlNodeList(grpCols, SqlParserPos.ZERO);
        return ctx.grpBy;
    }

    @Override
    protected SqlNode visitOperator(ASTNode node, ParseContext ctx) {
        List children = node.getChildren();
        if (((ArrayList)children).size() == 1) {
            return this.visitUnaryOperator(node, ctx);
        }
        if (((ArrayList)children).size() == 2) {
            return this.visitBinaryOperator(node, ctx);
        }
        throw new RuntimeException(String.format("Unhandled AST operator: %s with > 2 children, tree: %s", node.getText(), node.dump()));
    }

    private SqlNode visitUnaryOperator(ASTNode node, ParseContext ctx) {
        SqlNode operand = (SqlNode)this.visit((ASTNode)((ArrayList)node.getChildren()).get(0), ctx);
        SqlOperator operator = this.functionResolver.resolveUnaryOperator(node.getText());
        return operator.createCall(SqlParserPos.ZERO, new SqlNode[]{operand});
    }

    private SqlNode visitBinaryOperator(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes.size() == 2 ? 1 : 0) != 0);
        return this.functionResolver.resolveBinaryOperator(node.getText()).createCall(SqlParserPos.ZERO, sqlNodes);
    }

    @Override
    protected SqlNode visitDotOperator(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes != null && sqlNodes.size() == 2 ? 1 : 0) != 0);
        if (sqlNodes.get(0) instanceof SqlIdentifier) {
            SqlIdentifier left = (SqlIdentifier)sqlNodes.get(0);
            SqlIdentifier right = (SqlIdentifier)sqlNodes.get(1);
            Iterable names = Iterables.concat((Iterable)left.names, (Iterable)right.names);
            return new SqlIdentifier((List)ImmutableList.copyOf((Iterable)names), SqlParserPos.ZERO);
        }
        return FunctionFieldReferenceOperator.DOT.createCall(SqlParserPos.ZERO, sqlNodes);
    }

    @Override
    protected SqlNode visitLParen(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes.size() == 2 ? 1 : 0) != 0);
        return SqlStdOperatorTable.ITEM.createCall(SqlParserPos.ZERO, sqlNodes);
    }

    @Override
    protected SqlNode visitFunctionStar(ASTNode node, ParseContext ctx) {
        ASTNode functionNode = (ASTNode)((ArrayList)node.getChildren()).get(0);
        List functions = SqlStdOperatorTable.instance().getOperatorList().stream().filter(f -> functionNode.getText().equalsIgnoreCase(f.getName())).collect(Collectors.toList());
        Preconditions.checkState((functions.size() == 1 ? 1 : 0) != 0);
        return new SqlBasicCall((SqlOperator)functions.get(0), new SqlNode[]{new SqlIdentifier("", SqlParserPos.ZERO)}, SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitFunctionDistinct(ASTNode node, ParseContext ctx) {
        return this.visitFunctionInternal(node, ctx, SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO));
    }

    @Override
    protected SqlNode visitFunction(ASTNode node, ParseContext ctx) {
        return this.visitFunctionInternal(node, ctx, null);
    }

    private SqlNode visitFunctionInternal(ASTNode node, ParseContext ctx, SqlLiteral quantifier) {
        List children = node.getChildren();
        Preconditions.checkState((((ArrayList)children).size() > 0 ? 1 : 0) != 0);
        ASTNode functionNode = (ASTNode)((ArrayList)children).get(0);
        String functionName = functionNode.getText();
        List sqlOperands = this.visitChildren(children, ctx);
        Function hiveFunction = this.functionResolver.tryResolve(functionName, ctx.hiveTable.orElse(null), sqlOperands.size() - 1);
        SqlNode lastSqlOperand = (SqlNode)sqlOperands.get(sqlOperands.size() - 1);
        if (lastSqlOperand instanceof SqlWindow) {
            SqlCall func = hiveFunction.createCall((SqlNode)sqlOperands.get(0), sqlOperands.subList(1, sqlOperands.size() - 1), quantifier);
            SqlNode window = lastSqlOperand;
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.OVER, new SqlNode[]{func, window}, SqlParserPos.ZERO);
        }
        if (functionName.equalsIgnoreCase("SUBSTRING")) {
            SqlNode originalNode = (SqlNode)sqlOperands.get(0);
            SqlIdentifier substrNode = new SqlIdentifier((List)ImmutableList.of((Object)"SUBSTR"), null, originalNode.getParserPosition(), null);
            hiveFunction = this.functionResolver.tryResolve("SUBSTR", ctx.hiveTable.orElse(null), sqlOperands.size() - 1);
            return hiveFunction.createCall((SqlNode)substrNode, sqlOperands.subList(1, sqlOperands.size()), quantifier);
        }
        return hiveFunction.createCall((SqlNode)sqlOperands.get(0), sqlOperands.subList(1, sqlOperands.size()), quantifier);
    }

    @Override
    protected SqlNode visitSelectExpr(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        if (sqlNodes.size() == 1) {
            return (SqlNode)sqlNodes.get(0);
        }
        if (sqlNodes.size() == 2) {
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        }
        if (sqlNodes.size() >= 3) {
            ArrayList nodes = new ArrayList();
            nodes.add(sqlNodes.get(0));
            nodes.add(sqlNodes.get(sqlNodes.size() - 1));
            nodes.addAll(sqlNodes.subList(1, sqlNodes.size() - 1));
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, nodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitSelectDistinct(ASTNode node, ParseContext ctx) {
        ctx.keywords = new SqlNodeList((Collection)ImmutableList.of((Object)SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO)), SqlParserPos.ZERO);
        return this.visitSelect(node, ctx);
    }

    @Override
    protected SqlNode visitSelect(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        ctx.selects = new SqlNodeList(sqlNodes, SqlParserPos.ZERO);
        return ctx.selects;
    }

    @Override
    protected SqlNode visitTabRefNode(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes != null && !sqlNodes.isEmpty() ? 1 : 0) != 0);
        if (sqlNodes.size() == 1) {
            return (SqlNode)sqlNodes.get(0);
        }
        if (sqlNodes.size() == 2) {
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitTabnameNode(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        List names = sqlNodes.stream().map(s -> ((SqlIdentifier)s).names).flatMap(Collection::stream).collect(Collectors.toList());
        return new SqlIdentifier(names, SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitSubqueryOp(ASTNode node, ParseContext ctx) {
        throw new UnhandledASTTokenException(node);
    }

    private SqlOperator getSubQueryOp(ASTNode node, ParseContext ctx) {
        Preconditions.checkState((((ArrayList)node.getChildren()).size() == 1 ? 1 : 0) != 0, (Object)node.dump());
        String opName = ((ASTNode)((ArrayList)node.getChildren()).get(0)).getText();
        if (opName.equalsIgnoreCase("in")) {
            return SqlStdOperatorTable.IN;
        }
        if (opName.equalsIgnoreCase("exists")) {
            return SqlStdOperatorTable.EXISTS;
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitSubqueryExpr(ASTNode node, ParseContext ctx) {
        List children = node.getChildren();
        Preconditions.checkState((((ArrayList)children).size() >= 2 ? 1 : 0) != 0);
        SqlOperator op = this.getSubQueryOp((ASTNode)((ArrayList)node.getChildren()).get(0), ctx);
        SqlNode subQuery = (SqlNode)this.visit((ASTNode)((ArrayList)children).get(1), ctx);
        ArrayList<SqlNode> operands = new ArrayList<SqlNode>();
        operands.add(subQuery);
        if (((ArrayList)children).size() == 3) {
            SqlNode lhs = (SqlNode)this.visit((ASTNode)((ArrayList)children).get(2), ctx);
            operands.add(0, lhs);
        }
        return new SqlBasicCall(op, operands.toArray(new SqlNode[0]), SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitSubquery(ASTNode node, ParseContext ctx) {
        ParseContext subQueryContext = new ParseContext(ctx.getHiveTable().orElse(null));
        List sqlNodes = this.visitChildren(node, subQueryContext);
        if (sqlNodes.size() == 1) {
            return (SqlNode)sqlNodes.get(0);
        }
        if (sqlNodes.size() == 2) {
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitFrom(ASTNode node, ParseContext ctx) {
        List children = this.visitChildren(node, ctx);
        if (children.size() == 1) {
            ctx.from = (SqlNode)children.get(0);
            return (SqlNode)children.get(0);
        }
        throw new UnsupportedASTException(node.dump());
    }

    @Override
    protected SqlNode visitIdentifier(ASTNode node, ParseContext ctx) {
        return new SqlIdentifier(node.getText(), SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitStringLiteral(ASTNode node, ParseContext ctx) {
        String text = node.getText();
        Preconditions.checkState((text.length() >= 2 ? 1 : 0) != 0);
        return SqlLiteral.createCharString((String)text.substring(1, text.length() - 1), (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitBigintLiteral(ASTNode node, ParseContext ctx) {
        String text = node.getText();
        Preconditions.checkState((text.length() >= 2 ? 1 : 0) != 0);
        return SqlLiteral.createExactNumeric((String)text.substring(0, text.length() - 1), (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitDateLiteral(ASTNode node, ParseContext ctx) {
        String text = node.getText();
        Preconditions.checkState((text.length() >= 2 ? 1 : 0) != 0);
        return SqlLiteral.createCharString((String)text.substring(1, text.length() - 1), (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitQueryNode(ASTNode node, ParseContext ctx) {
        List children = node.getChildren();
        Preconditions.checkState((children != null && !((ArrayList)children).isEmpty() ? 1 : 0) != 0);
        SqlNode cte = null;
        ParseContext qc = new ParseContext(ctx.getHiveTable().orElse(null));
        for (Node child : node.getChildren()) {
            ASTNode ast = (ASTNode)child;
            if (ast.getType() == 668) {
                cte = (SqlNode)this.visit(ast, new ParseContext(null));
                continue;
            }
            this.visit(ast, qc);
        }
        SqlSelect select = new SqlSelect(SqlParserPos.ZERO, qc.keywords, qc.selects, qc.from, qc.where, qc.grpBy, qc.having, null, qc.orderBy, null, qc.fetch);
        if (cte != null) {
            return new SqlWith(SqlParserPos.ZERO, (SqlNodeList)cte, (SqlNode)select);
        }
        return select;
    }

    @Override
    protected SqlNode visitNil(ASTNode node, ParseContext ctx) {
        return (SqlNode)this.visitChildren(node, ctx).get(0);
    }

    @Override
    protected SqlNode visitBoolean(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.BOOLEAN);
    }

    @Override
    protected SqlNode visitInt(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.INTEGER);
    }

    @Override
    protected SqlNode visitSmallInt(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.SMALLINT);
    }

    @Override
    protected SqlNode visitBigInt(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.BIGINT);
    }

    @Override
    protected SqlNode visitTinyInt(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.TINYINT);
    }

    @Override
    protected SqlNode visitFloat(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.FLOAT);
    }

    @Override
    protected SqlNode visitDouble(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.DOUBLE);
    }

    @Override
    protected SqlNode visitVarchar(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.VARCHAR);
    }

    @Override
    protected SqlNode visitChar(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.CHAR);
    }

    @Override
    protected SqlNode visitString(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.VARCHAR);
    }

    @Override
    protected SqlNode visitBinary(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.BINARY);
    }

    @Override
    protected SqlNode visitDecimal(ASTNode node, ParseContext ctx) {
        if (node.getChildCount() == 2) {
            try {
                SqlBasicTypeNameSpec typeNameSpec = new SqlBasicTypeNameSpec(SqlTypeName.DECIMAL, Integer.parseInt(((ASTNode)((ArrayList)node.getChildren()).get(0)).getText()), Integer.parseInt(((ASTNode)((ArrayList)node.getChildren()).get(1)).getText()), SqlParserPos.ZERO);
                return new SqlDataTypeSpec((SqlTypeNameSpec)typeNameSpec, SqlParserPos.ZERO);
            }
            catch (NumberFormatException e) {
                return this.createBasicTypeSpec(SqlTypeName.DECIMAL);
            }
        }
        return this.createBasicTypeSpec(SqlTypeName.DECIMAL);
    }

    @Override
    protected SqlNode visitDate(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.DATE);
    }

    @Override
    protected SqlNode visitTimestamp(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.TIMESTAMP);
    }

    @Override
    protected SqlNode visitIsNull(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createCharString((String)"is null", (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitIsNotNull(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createCharString((String)"is not null", (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitKeywordLiteral(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createCharString((String)node.getText(), (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitCTE(ASTNode node, ParseContext ctx) {
        List children = node.getChildren();
        Preconditions.checkState((children != null && !((ArrayList)children).isEmpty() ? 1 : 0) != 0);
        List sqlNodeList = this.visitChildren(node, ctx);
        ArrayList<SqlWithItem> withItemList = new ArrayList<SqlWithItem>();
        for (SqlNode sqlNode : sqlNodeList) {
            SqlBasicCall call = (SqlBasicCall)sqlNode;
            SqlNode definition = (SqlNode)call.getOperandList().get(0);
            SqlNode alias = (SqlNode)call.getOperandList().get(1);
            SqlWithItem withItem = new SqlWithItem(SqlParserPos.ZERO, (SqlIdentifier)alias, null, definition);
            withItemList.add(withItem);
        }
        SqlNodeList result = new SqlNodeList(withItemList, SqlParserPos.ZERO);
        return result;
    }

    @Override
    protected SqlNode visitWindowSpec(ASTNode node, ParseContext ctx) {
        ctx = new ParseContext(ctx.hiveTable.orElse(null));
        SqlWindow partitionSpec = (SqlWindow)this.visitOptionalChildByType(node, ctx, 789);
        SqlWindow windowRange = (SqlWindow)this.visitOptionalChildByType(node, ctx, 932);
        SqlWindow windowValues = (SqlWindow)this.visitOptionalChildByType(node, ctx, 934);
        SqlWindow window = windowRange != null ? windowRange : windowValues;
        return new SqlWindow(SqlParserPos.ZERO, null, null, partitionSpec == null ? SqlNodeList.EMPTY : partitionSpec.getPartitionList(), partitionSpec == null ? SqlNodeList.EMPTY : partitionSpec.getOrderList(), SqlLiteral.createBoolean((windowRange != null ? 1 : 0) != 0, (SqlParserPos)SqlParserPos.ZERO), window == null ? null : window.getLowerBound(), window == null ? null : window.getUpperBound(), null);
    }

    @Override
    protected SqlNode visitPartitioningSpec(ASTNode node, ParseContext ctx) {
        SqlNode partitionList = (SqlNode)this.visitOptionalChildByType(node, ctx, 687);
        SqlNode orderList = (SqlNode)this.visitOptionalChildByType(node, ctx, 787);
        return new SqlWindow(SqlParserPos.ZERO, null, null, partitionList != null ? (SqlNodeList)partitionList : SqlNodeList.EMPTY, orderList != null ? (SqlNodeList)orderList : SqlNodeList.EMPTY, null, null, null, null);
    }

    @Override
    protected SqlNode visitDistributeBy(ASTNode node, ParseContext ctx) {
        return new SqlNodeList(this.visitChildren(node, ctx), SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitWindowRange(ASTNode node, ParseContext ctx) {
        List sqlNodeList = this.visitChildren(node, ctx);
        SqlNode preceding = (SqlNode)sqlNodeList.get(0);
        SqlNode following = sqlNodeList.size() < 2 ? null : (SqlNode)sqlNodeList.get(1);
        return new SqlWindow(SqlParserPos.ZERO, null, null, SqlNodeList.EMPTY, SqlNodeList.EMPTY, null, preceding, following, null);
    }

    @Override
    protected SqlNode visitWindowValues(ASTNode node, ParseContext ctx) {
        return this.visitWindowRange(node, ctx);
    }

    @Override
    protected SqlNode visitPreceding(ASTNode node, ParseContext ctx) {
        SqlNode sqlNode = (SqlNode)this.visitChildren(node, ctx).get(0);
        if (sqlNode.getKind() == SqlKind.LITERAL && sqlNode.toString().equalsIgnoreCase("'UNBOUNDED'")) {
            return SqlWindow.createUnboundedPreceding((SqlParserPos)SqlParserPos.ZERO);
        }
        return SqlWindow.createPreceding((SqlNode)sqlNode, (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitFollowing(ASTNode node, ParseContext ctx) {
        SqlNode sqlNode = (SqlNode)this.visitChildren(node, ctx).get(0);
        if (sqlNode.getKind() == SqlKind.LITERAL && sqlNode.toString().equalsIgnoreCase("'UNBOUNDED'")) {
            return SqlWindow.createUnboundedFollowing((SqlParserPos)SqlParserPos.ZERO);
        }
        return SqlWindow.createFollowing((SqlNode)sqlNode, (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitCurrentRow(ASTNode node, ParseContext ctx) {
        return SqlWindow.createCurrentRow((SqlParserPos)SqlParserPos.ZERO);
    }

    private SqlDataTypeSpec createBasicTypeSpec(SqlTypeName type) {
        SqlBasicTypeNameSpec typeNameSpec = new SqlBasicTypeNameSpec(type, SqlParserPos.ZERO);
        return new SqlDataTypeSpec((SqlTypeNameSpec)typeNameSpec, SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitTableTokOrCol(ASTNode node, ParseContext ctx) {
        return (SqlNode)this.visitChildren(node, ctx).get(0);
    }

    private SqlIntervalQualifier fromASTIntervalTypeToSqlIntervalQualifier(ASTNode node) {
        switch (node.getType()) {
            case 734: {
                return new SqlIntervalQualifier(TimeUnit.DAY, null, SqlParserPos.ZERO);
            }
            case 736: {
                return new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
            }
            case 737: {
                return new SqlIntervalQualifier(TimeUnit.HOUR, null, SqlParserPos.ZERO);
            }
            case 738: {
                return new SqlIntervalQualifier(TimeUnit.MINUTE, null, SqlParserPos.ZERO);
            }
            case 739: {
                return new SqlIntervalQualifier(TimeUnit.MONTH, null, SqlParserPos.ZERO);
            }
            case 740: {
                return new SqlIntervalQualifier(TimeUnit.SECOND, null, SqlParserPos.ZERO);
            }
            case 741: {
                return new SqlIntervalQualifier(TimeUnit.YEAR, null, SqlParserPos.ZERO);
            }
            case 743: {
                return new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
            }
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitIntervalLiteral(ASTNode node, ParseContext ctx) {
        SqlIntervalQualifier intervalQualifier = this.fromASTIntervalTypeToSqlIntervalQualifier(node);
        String text = node.getToken().getText();
        String unquotedText = text.replaceAll("['\"]", "");
        return SqlLiteral.createInterval((int)1, (String)unquotedText, (SqlIntervalQualifier)intervalQualifier, (SqlParserPos)SqlParserPos.ZERO);
    }

    static class ParseContext {
        private final Optional<Table> hiveTable;
        SqlNodeList keywords;
        SqlNode from;
        SqlNodeList selects;
        SqlNode where;
        SqlNodeList grpBy;
        SqlNode having;
        SqlNode fetch;
        SqlNodeList orderBy;

        ParseContext(@Nullable Table hiveTable) {
            this.hiveTable = Optional.ofNullable(hiveTable);
        }

        Optional<Table> getHiveTable() {
            return this.hiveTable;
        }
    }
}

