/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Locale;
import libsvm.svm_parameter;

public final class LibSvmUtils {
    private LibSvmUtils() {
    }

    public static svm_parameter parseParameters(String paramString) {
        svm_parameter params = new svm_parameter();
        params.kernel_type = 0;
        params.degree = 3;
        params.gamma = 0.0;
        params.coef0 = 0.0;
        params.nu = 0.5;
        params.cache_size = 100.0;
        params.C = 1.0;
        params.eps = 0.1;
        params.p = 0.1;
        params.shrinking = 1;
        params.probability = 0;
        params.nr_weight = 0;
        params.weight_label = new int[0];
        params.weight = new double[0];
        block18: for (String split : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)paramString)) {
            String key;
            String[] pair = split.split("=");
            Preconditions.checkArgument((pair.length == 2 ? 1 : 0) != 0, (Object)"Invalid hyperparameters string for libsvm");
            String value = pair[1].trim();
            switch (key = pair[0].trim()) {
                case "kernel": {
                    params.kernel_type = LibSvmUtils.parseKernelType(value);
                    continue block18;
                }
                case "degree": {
                    params.degree = Integer.parseInt(value);
                    continue block18;
                }
                case "gamma": {
                    params.gamma = Double.parseDouble(value);
                    continue block18;
                }
                case "coef0": {
                    params.coef0 = Double.parseDouble(value);
                    continue block18;
                }
                case "C": {
                    params.C = Double.parseDouble(value);
                    continue block18;
                }
                case "nu": {
                    params.nu = Double.parseDouble(value);
                    continue block18;
                }
                case "eps": {
                    params.eps = Double.parseDouble(value);
                    continue block18;
                }
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unknown parameter %s", pair[0]));
        }
        return params;
    }

    private static int parseKernelType(String value) {
        switch (value.toLowerCase(Locale.ENGLISH)) {
            case "linear": {
                return 0;
            }
            case "poly": {
                return 1;
            }
            case "rbf": {
                return 2;
            }
            case "sigmoid": {
                return 3;
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unknown kernel type %s", value));
    }
}

