/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import com.google.common.collect.ImmutableList;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import java.util.List;

public final class MLFeaturesFunctions {
    public static final List<Class<?>> ML_FEATURE_FUNCTIONS = ImmutableList.of(Features1.class, Features2.class, Features3.class, Features4.class, Features5.class, Features6.class, Features7.class, Features8.class, Features9.class, Features10.class);
    private static final String MAP_BIGINT_DOUBLE = "map(bigint,double)";

    private MLFeaturesFunctions() {
    }

    private static Block featuresHelper(PageBuilder pageBuilder, double ... features) {
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder mapBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < features.length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            DoubleType.DOUBLE.writeDouble(blockBuilder, features[i]);
        }
        mapBlockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return (Block)mapBlockBuilder.getObject(mapBlockBuilder.getPositionCount() - 1, Block.class);
    }

    @ScalarFunction(value="features")
    public static class Features1 {
        private final PageBuilder pageBuilder;

        public Features1(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1);
        }
    }

    @ScalarFunction(value="features")
    public static class Features2 {
        private final PageBuilder pageBuilder;

        public Features2(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2);
        }
    }

    @ScalarFunction(value="features")
    public static class Features3 {
        private final PageBuilder pageBuilder;

        public Features3(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2, f3);
        }
    }

    @ScalarFunction(value="features")
    public static class Features4 {
        private final PageBuilder pageBuilder;

        public Features4(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2, f3, f4);
        }
    }

    @ScalarFunction(value="features")
    public static class Features5 {
        private final PageBuilder pageBuilder;

        public Features5(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2, f3, f4, f5);
        }
    }

    @ScalarFunction(value="features")
    public static class Features6 {
        private final PageBuilder pageBuilder;

        public Features6(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2, f3, f4, f5, f6);
        }
    }

    @ScalarFunction(value="features")
    public static class Features7 {
        private final PageBuilder pageBuilder;

        public Features7(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2, f3, f4, f5, f6, f7);
        }
    }

    @ScalarFunction(value="features")
    public static class Features8 {
        private final PageBuilder pageBuilder;

        public Features8(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2, f3, f4, f5, f6, f7, f8);
        }
    }

    @ScalarFunction(value="features")
    public static class Features9 {
        private final PageBuilder pageBuilder;

        public Features9(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8, @SqlType(value="double") double f9) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2, f3, f4, f5, f6, f7, f8, f9);
        }
    }

    @ScalarFunction(value="features")
    public static class Features10 {
        private final PageBuilder pageBuilder;

        public Features10(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8, @SqlType(value="double") double f9, @SqlType(value="double") double f10) {
            return MLFeaturesFunctions.featuresHelper(this.pageBuilder, f1, f2, f3, f4, f5, f6, f7, f8, f9, f10);
        }
    }
}

