/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

final class StsTokenExchangeResponse {
    private final AccessToken accessToken;
    private final String issuedTokenType;
    private final String tokenType;
    @Nullable
    private final Long expiresInSeconds;
    @Nullable
    private final String refreshToken;
    @Nullable
    private final List<String> scopes;

    private StsTokenExchangeResponse(String accessToken, String issuedTokenType, String tokenType, @Nullable Long expiresInSeconds, @Nullable String refreshToken, @Nullable List<String> scopes) {
        Preconditions.checkNotNull(accessToken);
        this.expiresInSeconds = expiresInSeconds;
        Long expiresAtMilliseconds = expiresInSeconds == null ? null : Long.valueOf(System.currentTimeMillis() + expiresInSeconds * 1000L);
        Date date = expiresAtMilliseconds == null ? null : new Date(expiresAtMilliseconds);
        this.accessToken = new AccessToken(accessToken, date);
        this.issuedTokenType = Preconditions.checkNotNull(issuedTokenType);
        this.tokenType = Preconditions.checkNotNull(tokenType);
        this.refreshToken = refreshToken;
        this.scopes = scopes;
    }

    public static Builder newBuilder(String accessToken, String issuedTokenType, String tokenType) {
        return new Builder(accessToken, issuedTokenType, tokenType);
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public String getIssuedTokenType() {
        return this.issuedTokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    @Nullable
    public Long getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public List<String> getScopes() {
        if (this.scopes == null) {
            return null;
        }
        return new ArrayList<String>(this.scopes);
    }

    public static class Builder {
        private final String accessToken;
        private final String issuedTokenType;
        private final String tokenType;
        @Nullable
        private Long expiresInSeconds;
        @Nullable
        private String refreshToken;
        @Nullable
        private List<String> scopes;

        private Builder(String accessToken, String issuedTokenType, String tokenType) {
            this.accessToken = accessToken;
            this.issuedTokenType = issuedTokenType;
            this.tokenType = tokenType;
        }

        public Builder setExpiresInSeconds(long expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
            return this;
        }

        public Builder setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder setScopes(List<String> scopes) {
            if (scopes != null) {
                this.scopes = new ArrayList<String>(scopes);
            }
            return this;
        }

        public StsTokenExchangeResponse build() {
            return new StsTokenExchangeResponse(this.accessToken, this.issuedTokenType, this.tokenType, this.expiresInSeconds, this.refreshToken, this.scopes);
        }
    }
}

