/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.EditShape;
import com.linkedin.coral.com.esri.core.geometry.Envelope1D;
import com.linkedin.coral.com.esri.core.geometry.GeometryException;
import com.linkedin.coral.com.esri.core.geometry.Line;
import com.linkedin.coral.com.esri.core.geometry.NumberUtils;
import com.linkedin.coral.com.esri.core.geometry.Point2D;
import com.linkedin.coral.com.esri.core.geometry.Treap;

class SweepMonkierComparator
extends Treap.MonikerComparator {
    protected EditShape m_shape;
    protected boolean m_b_intersection_detected;
    protected Point2D m_point_of_interest;
    protected Line m_line_1;
    protected Envelope1D m_env;
    protected int m_vertex_1;
    protected int m_current_node;
    protected double m_min_dist;
    protected double m_tolerance;

    SweepMonkierComparator(EditShape shape, double tol) {
        this.m_shape = shape;
        this.m_tolerance = tol;
        this.m_b_intersection_detected = false;
        this.m_vertex_1 = -1;
        this.m_env = new Envelope1D();
        this.m_point_of_interest = new Point2D();
        this.m_point_of_interest.setNaN();
        this.m_line_1 = new Line();
        this.m_current_node = -1;
        this.m_min_dist = NumberUtils.doubleMax();
    }

    int getCurrentNode() {
        return this.m_current_node;
    }

    void clearIntersectionDetectedFlag() {
        this.m_b_intersection_detected = false;
        this.m_min_dist = NumberUtils.doubleMax();
    }

    boolean intersectionDetected() {
        return this.m_b_intersection_detected;
    }

    void setPoint(Point2D pt) {
        this.m_point_of_interest.setCoords(pt);
    }

    @Override
    int compare(Treap treap, int node) {
        int vertex = treap.getElement(node);
        return this.compareVertex_(treap, node, vertex);
    }

    protected int compareVertex_(Treap treap, int node, int vertex) {
        boolean bCurve;
        boolean bl = bCurve = this.m_shape.getSegment(vertex) != null;
        if (!bCurve) {
            this.m_shape.queryLineConnector(vertex, this.m_line_1);
            this.m_env.setCoordsNoNaN_(this.m_line_1.getStartX(), this.m_line_1.getEndX());
        }
        if (bCurve) {
            throw new GeometryException("not implemented");
        }
        if (this.m_point_of_interest.x + this.m_tolerance < this.m_env.vmin) {
            return -1;
        }
        if (this.m_point_of_interest.x - this.m_tolerance > this.m_env.vmax) {
            return 1;
        }
        if (this.m_line_1.getStartY() == this.m_line_1.getEndY()) {
            this.m_current_node = node;
            this.m_b_intersection_detected = true;
            return 0;
        }
        this.m_line_1.orientBottomUp_();
        Point2D start = this.m_line_1.getStartXY();
        Point2D vector = new Point2D();
        vector.sub(this.m_line_1.getEndXY(), start);
        vector.rightPerpendicular();
        Point2D v_2 = new Point2D();
        v_2.sub(this.m_point_of_interest, start);
        double dot = vector.dotProduct(v_2);
        dot /= vector.length();
        if (dot < -this.m_tolerance * 10.0) {
            return -1;
        }
        if (dot > this.m_tolerance * 10.0) {
            return 1;
        }
        if (this.m_line_1.isIntersecting(this.m_point_of_interest, this.m_tolerance)) {
            double absDot = Math.abs(dot);
            if (absDot < this.m_min_dist) {
                this.m_current_node = node;
                this.m_min_dist = absDot;
            }
            this.m_b_intersection_detected = true;
            if (absDot < 0.25 * this.m_tolerance) {
                return 0;
            }
        }
        return dot < 0.0 ? -1 : 1;
    }
}

