/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.BasicSliceOutput;
import io.airlift.slice.JvmUtils;
import io.airlift.slice.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public final class Slice
implements Comparable<Slice> {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Slice.class).instanceSize());
    private static final Object COMPACT = new byte[0];
    private static final Object NOT_COMPACT = null;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private final Object base;
    private final long address;
    private final int size;
    private final long retainedSize;
    private final Object reference;
    private int hash;

    Slice() {
        this.base = null;
        this.address = 0L;
        this.size = 0;
        this.retainedSize = INSTANCE_SIZE;
        this.reference = COMPACT;
    }

    Slice(byte[] base) {
        Objects.requireNonNull(base, "base is null");
        this.base = base;
        this.address = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        this.size = base.length;
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
        this.reference = COMPACT;
    }

    Slice(byte[] base, int offset, int length) {
        Objects.requireNonNull(base, "base is null");
        Preconditions.checkPositionIndexes(offset, offset + length, base.length);
        this.base = base;
        this.address = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        this.size = length;
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
        this.reference = offset == 0 && length == base.length ? COMPACT : NOT_COMPACT;
    }

    Slice(boolean[] base, int offset, int length) {
        Objects.requireNonNull(base, "base is null");
        Preconditions.checkPositionIndexes(offset, offset + length, base.length);
        this.base = base;
        this.address = SizeOf.sizeOfBooleanArray(offset);
        this.size = Math.multiplyExact(length, Unsafe.ARRAY_BOOLEAN_INDEX_SCALE);
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
        this.reference = offset == 0 && length == base.length ? COMPACT : NOT_COMPACT;
    }

    Slice(short[] base, int offset, int length) {
        Objects.requireNonNull(base, "base is null");
        Preconditions.checkPositionIndexes(offset, offset + length, base.length);
        this.base = base;
        this.address = SizeOf.sizeOfShortArray(offset);
        this.size = Math.multiplyExact(length, Unsafe.ARRAY_SHORT_INDEX_SCALE);
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
        this.reference = offset == 0 && length == base.length ? COMPACT : NOT_COMPACT;
    }

    Slice(int[] base, int offset, int length) {
        Objects.requireNonNull(base, "base is null");
        Preconditions.checkPositionIndexes(offset, offset + length, base.length);
        this.base = base;
        this.address = SizeOf.sizeOfIntArray(offset);
        this.size = Math.multiplyExact(length, Unsafe.ARRAY_INT_INDEX_SCALE);
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
        this.reference = offset == 0 && length == base.length ? COMPACT : NOT_COMPACT;
    }

    Slice(long[] base, int offset, int length) {
        Objects.requireNonNull(base, "base is null");
        Preconditions.checkPositionIndexes(offset, offset + length, base.length);
        this.base = base;
        this.address = SizeOf.sizeOfLongArray(offset);
        this.size = Math.multiplyExact(length, Unsafe.ARRAY_LONG_INDEX_SCALE);
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
        this.reference = offset == 0 && length == base.length ? COMPACT : NOT_COMPACT;
    }

    Slice(float[] base, int offset, int length) {
        Objects.requireNonNull(base, "base is null");
        Preconditions.checkPositionIndexes(offset, offset + length, base.length);
        this.base = base;
        this.address = SizeOf.sizeOfFloatArray(offset);
        this.size = Math.multiplyExact(length, Unsafe.ARRAY_FLOAT_INDEX_SCALE);
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
        this.reference = offset == 0 && length == base.length ? COMPACT : NOT_COMPACT;
    }

    Slice(double[] base, int offset, int length) {
        Objects.requireNonNull(base, "base is null");
        Preconditions.checkPositionIndexes(offset, offset + length, base.length);
        this.base = base;
        this.address = SizeOf.sizeOfDoubleArray(offset);
        this.size = Math.multiplyExact(length, Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
        this.reference = offset == 0 && length == base.length ? COMPACT : NOT_COMPACT;
    }

    Slice(@Nullable Object base, long address, int size, long retainedSize, @Nullable Object reference) {
        if (address <= 0L) {
            throw new IllegalArgumentException(String.format("Invalid address: %s", address));
        }
        if (size <= 0) {
            throw new IllegalArgumentException(String.format("Invalid size: %s", size));
        }
        Preconditions.checkArgument(address + (long)size >= (long)size, "Address + size is greater than 64 bits");
        this.reference = reference;
        this.base = base;
        this.address = address;
        this.size = size;
        this.retainedSize = retainedSize;
    }

    public Object getBase() {
        return this.base;
    }

    public long getAddress() {
        return this.address;
    }

    public int length() {
        return this.size;
    }

    public long getRetainedSize() {
        return this.retainedSize;
    }

    public boolean isCompact() {
        return this.reference == COMPACT;
    }

    private void checkHasByteArray() throws UnsupportedOperationException {
        if (!this.hasByteArray()) {
            throw new UnsupportedOperationException("Slice is not backed by a byte array");
        }
    }

    public boolean hasByteArray() {
        return this.base instanceof byte[];
    }

    public byte[] byteArray() throws UnsupportedOperationException {
        this.checkHasByteArray();
        return (byte[])this.base;
    }

    public int byteArrayOffset() throws UnsupportedOperationException {
        this.checkHasByteArray();
        return (int)(this.address - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
    }

    public void fill(byte value) {
        int length;
        int offset = 0;
        long longValue = Slice.fillLong(value);
        for (length = this.size; length >= 8; length -= 8) {
            JvmUtils.unsafe.putLong(this.base, this.address + (long)offset, longValue);
            offset += 8;
        }
        while (length > 0) {
            JvmUtils.unsafe.putByte(this.base, this.address + (long)offset, value);
            ++offset;
            --length;
        }
    }

    public void clear() {
        this.clear(0, this.size);
    }

    public void clear(int offset, int length) {
        while (length >= 8) {
            JvmUtils.unsafe.putLong(this.base, this.address + (long)offset, 0L);
            offset += 8;
            length -= 8;
        }
        while (length > 0) {
            JvmUtils.unsafe.putByte(this.base, this.address + (long)offset, (byte)0);
            ++offset;
            --length;
        }
    }

    public byte getByte(int index) {
        this.checkIndexLength(index, 1);
        return this.getByteUnchecked(index);
    }

    byte getByteUnchecked(int index) {
        return JvmUtils.unsafe.getByte(this.base, this.address + (long)index);
    }

    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    public short getShort(int index) {
        this.checkIndexLength(index, 2);
        return this.getShortUnchecked(index);
    }

    short getShortUnchecked(int index) {
        return JvmUtils.unsafe.getShort(this.base, this.address + (long)index);
    }

    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public int getInt(int index) {
        this.checkIndexLength(index, 4);
        return this.getIntUnchecked(index);
    }

    int getIntUnchecked(int index) {
        return JvmUtils.unsafe.getInt(this.base, this.address + (long)index);
    }

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public long getLong(int index) {
        this.checkIndexLength(index, 8);
        return this.getLongUnchecked(index);
    }

    long getLongUnchecked(int index) {
        return JvmUtils.unsafe.getLong(this.base, this.address + (long)index);
    }

    public float getFloat(int index) {
        this.checkIndexLength(index, 4);
        return JvmUtils.unsafe.getFloat(this.base, this.address + (long)index);
    }

    public double getDouble(int index) {
        this.checkIndexLength(index, 8);
        return JvmUtils.unsafe.getDouble(this.base, this.address + (long)index);
    }

    public void getBytes(int index, Slice destination) {
        this.getBytes(index, destination, 0, destination.length());
    }

    public void getBytes(int index, Slice destination, int destinationIndex, int length) {
        destination.setBytes(destinationIndex, this, index, length);
    }

    public void getBytes(int index, byte[] destination) {
        this.getBytes(index, destination, 0, destination.length);
    }

    public void getBytes(int index, byte[] destination, int destinationIndex, int length) {
        this.checkIndexLength(index, length);
        Preconditions.checkPositionIndexes(destinationIndex, destinationIndex + length, destination.length);
        Slice.copyMemory(this.base, this.address + (long)index, destination, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)destinationIndex, length);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.length());
    }

    public byte[] getBytes(int index, int length) {
        byte[] bytes = new byte[length];
        this.getBytes(index, bytes, 0, length);
        return bytes;
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndexLength(index, length);
        if (this.hasByteArray()) {
            out.write(this.byteArray(), this.byteArrayOffset() + index, length);
            return;
        }
        byte[] buffer = new byte[4096];
        while (length > 0) {
            int size = Math.min(buffer.length, length);
            this.getBytes(index, buffer, 0, size);
            out.write(buffer, 0, size);
            length -= size;
            index += size;
        }
    }

    public void setByte(int index, int value) {
        this.checkIndexLength(index, 1);
        this.setByteUnchecked(index, value);
    }

    void setByteUnchecked(int index, int value) {
        JvmUtils.unsafe.putByte(this.base, this.address + (long)index, (byte)(value & 0xFF));
    }

    public void setShort(int index, int value) {
        this.checkIndexLength(index, 2);
        this.setShortUnchecked(index, value);
    }

    void setShortUnchecked(int index, int value) {
        JvmUtils.unsafe.putShort(this.base, this.address + (long)index, (short)(value & 0xFFFF));
    }

    public void setInt(int index, int value) {
        this.checkIndexLength(index, 4);
        this.setIntUnchecked(index, value);
    }

    void setIntUnchecked(int index, int value) {
        JvmUtils.unsafe.putInt(this.base, this.address + (long)index, value);
    }

    public void setLong(int index, long value) {
        this.checkIndexLength(index, 8);
        this.setLongUnchecked(index, value);
    }

    void setLongUnchecked(int index, long value) {
        JvmUtils.unsafe.putLong(this.base, this.address + (long)index, value);
    }

    public void setFloat(int index, float value) {
        this.checkIndexLength(index, 4);
        JvmUtils.unsafe.putFloat(this.base, this.address + (long)index, value);
    }

    public void setDouble(int index, double value) {
        this.checkIndexLength(index, 8);
        JvmUtils.unsafe.putDouble(this.base, this.address + (long)index, value);
    }

    public void setBytes(int index, Slice source) {
        this.setBytes(index, source, 0, source.length());
    }

    public void setBytes(int index, Slice source, int sourceIndex, int length) {
        this.checkIndexLength(index, length);
        Preconditions.checkPositionIndexes(sourceIndex, sourceIndex + length, source.length());
        Slice.copyMemory(source.base, source.address + (long)sourceIndex, this.base, this.address + (long)index, length);
    }

    public void setBytes(int index, byte[] source) {
        this.setBytes(index, source, 0, source.length);
    }

    public void setBytes(int index, byte[] source, int sourceIndex, int length) {
        this.checkIndexLength(index, length);
        Preconditions.checkPositionIndexes(sourceIndex, sourceIndex + length, source.length);
        Slice.copyMemory(source, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)sourceIndex, this.base, this.address + (long)index, length);
    }

    public void setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndexLength(index, length);
        if (this.hasByteArray()) {
            byte[] bytes = this.byteArray();
            int offset = this.byteArrayOffset() + index;
            while (length > 0) {
                int bytesRead = in.read(bytes, offset, length);
                if (bytesRead < 0) {
                    throw new IndexOutOfBoundsException("End of stream");
                }
                length -= bytesRead;
                offset += bytesRead;
            }
            return;
        }
        byte[] bytes = new byte[4096];
        while (length > 0) {
            int bytesRead = in.read(bytes, 0, Math.min(bytes.length, length));
            if (bytesRead < 0) {
                throw new IndexOutOfBoundsException("End of stream");
            }
            Slice.copyMemory(bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET, this.base, this.address + (long)index, bytesRead);
            length -= bytesRead;
            index += bytesRead;
        }
    }

    public Slice slice(int index, int length) {
        if (index == 0 && length == this.length()) {
            return this;
        }
        this.checkIndexLength(index, length);
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        if (this.reference == COMPACT) {
            return new Slice(this.base, this.address + (long)index, length, this.retainedSize, NOT_COMPACT);
        }
        return new Slice(this.base, this.address + (long)index, length, this.retainedSize, this.reference);
    }

    public int indexOfByte(int b) {
        Preconditions.checkArgument(b >> 8 == 0, "byte value out of range");
        return this.indexOfByte((byte)b);
    }

    public int indexOfByte(byte b) {
        for (int i = 0; i < this.size; ++i) {
            if (this.getByteUnchecked(i) != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Slice slice) {
        return this.indexOf(slice, 0);
    }

    public int indexOf(Slice pattern, int offset) {
        if (this.size == 0 || offset >= this.size) {
            return -1;
        }
        if (pattern.length() == 0) {
            return offset;
        }
        if (pattern.length() < 4 || this.size < 8) {
            return this.indexOfBruteForce(pattern, offset);
        }
        int head = pattern.getIntUnchecked(0);
        int firstByteMask = head & 0xFF;
        firstByteMask |= firstByteMask << 8;
        firstByteMask |= firstByteMask << 16;
        int lastValidIndex = this.size - pattern.length();
        int index = offset;
        while (index <= lastValidIndex) {
            int value = this.getIntUnchecked(index);
            int valueXor = value ^ firstByteMask;
            int hasZeroBytes = valueXor - 0x1010101 & ~valueXor & 0x80808080;
            if (hasZeroBytes == 0) {
                index += 4;
                continue;
            }
            if (value == head && this.equalsUnchecked(index, pattern, 0, pattern.length())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    int indexOfBruteForce(Slice pattern, int offset) {
        if (this.size == 0 || offset >= this.size) {
            return -1;
        }
        if (pattern.length() == 0) {
            return offset;
        }
        byte firstByte = pattern.getByteUnchecked(0);
        int lastValidIndex = this.size - pattern.length();
        int index = offset;
        while (true) {
            if (index < lastValidIndex && this.getByteUnchecked(index) != firstByte) {
                ++index;
                continue;
            }
            if (index > lastValidIndex) break;
            if (this.equalsUnchecked(index, pattern, 0, pattern.length())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int compareTo(Slice that) {
        if (this == that) {
            return 0;
        }
        return this.compareTo(0, this.size, that, 0, that.size);
    }

    public int compareTo(int offset, int length, Slice that, int otherOffset, int otherLength) {
        int compareLength;
        if (this == that && offset == otherOffset && length == otherLength) {
            return 0;
        }
        this.checkIndexLength(offset, length);
        that.checkIndexLength(otherOffset, otherLength);
        long thisAddress = this.address + (long)offset;
        long thatAddress = that.address + (long)otherOffset;
        for (compareLength = Math.min(length, otherLength); compareLength >= 8; compareLength -= 8) {
            long thatLong;
            long thisLong = JvmUtils.unsafe.getLong(this.base, thisAddress);
            if (thisLong != (thatLong = JvmUtils.unsafe.getLong(that.base, thatAddress))) {
                return Slice.longBytesToLong(thisLong) < Slice.longBytesToLong(thatLong) ? -1 : 1;
            }
            thisAddress += 8L;
            thatAddress += 8L;
        }
        while (compareLength > 0) {
            byte thatByte;
            byte thisByte = JvmUtils.unsafe.getByte(this.base, thisAddress);
            int v = Slice.compareUnsignedBytes(thisByte, thatByte = JvmUtils.unsafe.getByte(that.base, thatAddress));
            if (v != 0) {
                return v;
            }
            ++thisAddress;
            ++thatAddress;
            --compareLength;
        }
        return Integer.compare(length, otherLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice that = (Slice)o;
        if (this.length() != that.length()) {
            return false;
        }
        return this.equalsUnchecked(0, that, 0, this.length());
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.hashCode(0, this.size);
        return this.hash;
    }

    public int hashCode(int offset, int length) {
        return (int)XxHash64.hash(this, offset, length);
    }

    public boolean equals(int offset, int length, Slice that, int otherOffset, int otherLength) {
        if (length != otherLength) {
            return false;
        }
        if (this == that && offset == otherOffset) {
            return true;
        }
        this.checkIndexLength(offset, length);
        that.checkIndexLength(otherOffset, otherLength);
        return this.equalsUnchecked(offset, that, otherOffset, length);
    }

    boolean equalsUnchecked(int offset, Slice that, int otherOffset, int length) {
        long thisAddress = this.address + (long)offset;
        long thatAddress = that.address + (long)otherOffset;
        while (length >= 8) {
            long thatLong;
            long thisLong = JvmUtils.unsafe.getLong(this.base, thisAddress);
            if (thisLong != (thatLong = JvmUtils.unsafe.getLong(that.base, thatAddress))) {
                return false;
            }
            thisAddress += 8L;
            thatAddress += 8L;
            length -= 8;
        }
        while (length > 0) {
            byte thatByte;
            byte thisByte = JvmUtils.unsafe.getByte(this.base, thisAddress);
            if (thisByte != (thatByte = JvmUtils.unsafe.getByte(that.base, thatAddress))) {
                return false;
            }
            ++thisAddress;
            ++thatAddress;
            --length;
        }
        return true;
    }

    public BasicSliceInput getInput() {
        return new BasicSliceInput(this);
    }

    public SliceOutput getOutput() {
        return new BasicSliceOutput(this);
    }

    public String toString(Charset charset) {
        return this.toString(0, this.length(), charset);
    }

    public String toStringUtf8() {
        return this.toString(StandardCharsets.UTF_8);
    }

    public String toStringAscii() {
        return this.toStringAscii(0, this.size);
    }

    public String toStringAscii(int index, int length) {
        this.checkIndexLength(index, length);
        if (length == 0) {
            return "";
        }
        if (this.hasByteArray()) {
            return new String(this.byteArray(), 0, this.byteArrayOffset() + index, length);
        }
        char[] chars = new char[length];
        for (int pos = index; pos < length; ++pos) {
            chars[pos] = (char)(this.getByteUnchecked(pos) & 0x7F);
        }
        return new String(chars);
    }

    public String toString(int index, int length, Charset charset) {
        if (length == 0) {
            return "";
        }
        if (this.hasByteArray()) {
            return new String(this.byteArray(), this.byteArrayOffset() + index, length, charset);
        }
        return new String(this.getBytes(index, length), charset);
    }

    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(0, this.size);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        this.checkIndexLength(index, length);
        if (this.length() == 0) {
            return EMPTY_BYTE_BUFFER;
        }
        if (this.hasByteArray()) {
            return ByteBuffer.wrap(this.byteArray(), this.byteArrayOffset() + index, length).slice();
        }
        if (this.reference instanceof ByteBuffer && ((ByteBuffer)this.reference).isDirect()) {
            ByteBuffer buffer = (ByteBuffer)this.reference;
            int position = Math.toIntExact(this.address - JvmUtils.bufferAddress(buffer)) + index;
            buffer = buffer.duplicate();
            buffer.position(position);
            buffer.limit(position + length);
            return buffer.slice();
        }
        throw new UnsupportedOperationException("Conversion to ByteBuffer not supported for this Slice");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Slice{");
        if (this.base != null) {
            builder.append("base=").append(Slice.identityToString(this.base)).append(", ");
        }
        builder.append("address=").append(this.address);
        builder.append(", length=").append(this.length());
        builder.append('}');
        return builder.toString();
    }

    private static String identityToString(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    private static void copyMemory(Object src, long srcAddress, Object dest, long destAddress, int length) {
        int bytesToCopy = length - length % 8;
        JvmUtils.unsafe.copyMemory(src, srcAddress, dest, destAddress, bytesToCopy);
        JvmUtils.unsafe.copyMemory(src, srcAddress + (long)bytesToCopy, dest, destAddress + (long)bytesToCopy, length - bytesToCopy);
    }

    private void checkIndexLength(int index, int length) {
        Preconditions.checkPositionIndexes(index, index + length, this.length());
    }

    private static long fillLong(byte value) {
        long longValue = (value & 0xFF) << 8 | value & 0xFF;
        longValue = longValue << 16 | longValue;
        longValue = longValue << 32 | longValue;
        return longValue;
    }

    private static int compareUnsignedBytes(byte thisByte, byte thatByte) {
        return Slice.unsignedByteToInt(thisByte) - Slice.unsignedByteToInt(thatByte);
    }

    private static int unsignedByteToInt(byte thisByte) {
        return thisByte & 0xFF;
    }

    private static long longBytesToLong(long bytes) {
        return Long.reverseBytes(bytes) ^ Long.MIN_VALUE;
    }
}

