/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.hdfs.FSDataInputStreamTail;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.iceberg.io.SeekableInputStream;

class HdfsInput
implements TrinoInput {
    private final FSDataInputStream stream;
    private final TrinoInputFile inputFile;

    public HdfsInput(FSDataInputStream stream, TrinoInputFile inputFile) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.inputFile = Objects.requireNonNull(inputFile, "inputFile is null");
    }

    @Override
    public SeekableInputStream inputStream() {
        return new HdfsSeekableInputStream(this.stream);
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.stream.readFully(position, buffer, bufferOffset, bufferLength);
    }

    @Override
    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        Slice tail = FSDataInputStreamTail.readTail((String)this.inputFile.location(), (long)this.inputFile.length(), (FSDataInputStream)this.stream, (int)bufferLength).getTailSlice();
        tail.getBytes(0, buffer, bufferOffset, tail.length());
        return tail.length();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private static class HdfsSeekableInputStream
    extends SeekableInputStream {
        private final FSDataInputStream stream;

        private HdfsSeekableInputStream(FSDataInputStream stream) {
            this.stream = Objects.requireNonNull(stream, "stream is null");
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public void close() throws IOException {
            this.stream.close();
        }
    }
}

