/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class HivePartitionKey {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(HivePartitionKey.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize() * 2L);
    public static final String HIVE_DEFAULT_DYNAMIC_PARTITION = "__HIVE_DEFAULT_PARTITION__";
    private final String name;
    private final String value;

    @JsonCreator
    public HivePartitionKey(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(value, "value is null");
        this.name = name;
        this.value = value.equals(HIVE_DEFAULT_DYNAMIC_PARTITION) ? "\\N" : value;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public long getEstimatedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.name) + SizeOf.estimatedSizeOf((String)this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.value).toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HivePartitionKey other = (HivePartitionKey)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }
}

