/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.hive.hive2rel.HiveToRelConverter;
import com.linkedin.coral.trino.rel2trino.RelToTrinoConverter;
import com.linkedin.coral.trino.rel2trino.functions.TrinoKeywordsConverter;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.CoralTableRedirectionResolver;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.LegacyHiveViewReader;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.CoralSemiTransactionalHiveMSCAdapter;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.type.TypeManager;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.hadoop.hive.metastore.TableType;

public final class ViewReaderUtil {
    public static final String ICEBERG_MATERIALIZED_VIEW_COMMENT = "Presto Materialized View";
    public static final String PRESTO_VIEW_FLAG = "presto_view";
    static final String VIEW_PREFIX = "/* Presto View: ";
    static final String VIEW_SUFFIX = " */";
    private static final JsonCodec<ConnectorViewDefinition> VIEW_CODEC = new JsonCodecFactory((Provider)new ObjectMapperProvider()).jsonCodec(ConnectorViewDefinition.class);

    private ViewReaderUtil() {
    }

    public static ViewReader createViewReader(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, TypeManager typeManager, BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> tableRedirectionResolver, MetadataProvider metadataProvider, boolean runHiveViewRunAsInvoker) {
        if (ViewReaderUtil.isPrestoView(table)) {
            return new PrestoViewReader();
        }
        if (HiveSessionProperties.isHiveViewsLegacyTranslation(session)) {
            return new LegacyHiveViewReader(runHiveViewRunAsInvoker);
        }
        return new HiveViewReader(new CoralSemiTransactionalHiveMSCAdapter(metastore, ViewReaderUtil.coralTableRedirectionResolver(session, tableRedirectionResolver, metadataProvider)), typeManager, runHiveViewRunAsInvoker);
    }

    private static CoralTableRedirectionResolver coralTableRedirectionResolver(ConnectorSession session, BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> tableRedirectionResolver, MetadataProvider metadataProvider) {
        return schemaTableName -> ((Optional)tableRedirectionResolver.apply(session, schemaTableName)).map(target -> {
            ConnectorTableSchema tableSchema = (ConnectorTableSchema)metadataProvider.getRelationMetadata(session, target).orElseThrow(() -> new TableNotFoundException(target.getSchemaTableName(), String.format("%s is redirected to %s, but that relation cannot be found", schemaTableName, target)));
            List columns = (List)tableSchema.getColumns().stream().filter(columnSchema -> !columnSchema.isHidden()).map(columnSchema -> new Column(columnSchema.getName(), HiveType.toHiveType(columnSchema.getType()), Optional.empty())).collect(ImmutableList.toImmutableList());
            Table table = Table.builder().setDatabaseName(schemaTableName.getSchemaName()).setTableName(schemaTableName.getTableName()).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns(columns).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat(HiveStorageFormat.TEXTFILE))).setOwner(Optional.empty()).build();
            return ThriftMetastoreUtil.toMetastoreApiTable(table);
        });
    }

    public static boolean isPrestoView(Table table) {
        return ViewReaderUtil.isPrestoView(table.getParameters());
    }

    public static boolean isPrestoView(Map<String, String> tableParameters) {
        return "true".equals(tableParameters.get(PRESTO_VIEW_FLAG));
    }

    public static boolean isHiveOrPrestoView(Table table) {
        return ViewReaderUtil.isHiveOrPrestoView(table.getTableType());
    }

    public static boolean isHiveOrPrestoView(String tableType) {
        return tableType.equals(TableType.VIRTUAL_VIEW.name());
    }

    public static boolean isTrinoMaterializedView(String tableType, Map<String, String> tableParameters) {
        return ViewReaderUtil.isHiveOrPrestoView(tableType) && ViewReaderUtil.isPrestoView(tableParameters) && tableParameters.get("comment").equalsIgnoreCase(ICEBERG_MATERIALIZED_VIEW_COMMENT);
    }

    public static boolean canDecodeView(Table table) {
        return table.getTableType().equals(TableType.VIRTUAL_VIEW.name());
    }

    public static String encodeViewData(ConnectorViewDefinition definition) {
        byte[] bytes = VIEW_CODEC.toJsonBytes((Object)definition);
        String data = Base64.getEncoder().encodeToString(bytes);
        return VIEW_PREFIX + data + VIEW_SUFFIX;
    }

    public static class PrestoViewReader
    implements ViewReader {
        @Override
        public ConnectorViewDefinition decodeViewData(String viewData, Table table, CatalogName catalogName) {
            return PrestoViewReader.decodeViewData(viewData);
        }

        public static ConnectorViewDefinition decodeViewData(String viewData) {
            HiveUtil.checkCondition(viewData.startsWith(ViewReaderUtil.VIEW_PREFIX), HiveErrorCode.HIVE_INVALID_VIEW_DATA, "View data missing prefix: %s", viewData);
            HiveUtil.checkCondition(viewData.endsWith(ViewReaderUtil.VIEW_SUFFIX), HiveErrorCode.HIVE_INVALID_VIEW_DATA, "View data missing suffix: %s", viewData);
            viewData = viewData.substring(ViewReaderUtil.VIEW_PREFIX.length());
            viewData = viewData.substring(0, viewData.length() - ViewReaderUtil.VIEW_SUFFIX.length());
            byte[] bytes = Base64.getDecoder().decode(viewData);
            return (ConnectorViewDefinition)VIEW_CODEC.fromJson(bytes);
        }
    }

    public static class HiveViewReader
    implements ViewReader {
        private final HiveMetastoreClient metastoreClient;
        private final TypeManager typeManager;
        private final boolean hiveViewsRunAsInvoker;

        public HiveViewReader(HiveMetastoreClient hiveMetastoreClient, TypeManager typeManager, boolean hiveViewsRunAsInvoker) {
            this.metastoreClient = Objects.requireNonNull(hiveMetastoreClient, "hiveMetastoreClient is null");
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            this.hiveViewsRunAsInvoker = hiveViewsRunAsInvoker;
        }

        @Override
        public ConnectorViewDefinition decodeViewData(String viewSql, Table table, CatalogName catalogName) {
            try {
                HiveToRelConverter hiveToRelConverter = new HiveToRelConverter(this.metastoreClient);
                RelNode rel = hiveToRelConverter.convertView(table.getDatabaseName(), table.getTableName());
                RelToTrinoConverter relToTrino = new RelToTrinoConverter();
                String trinoSql = relToTrino.convert(rel);
                RelDataType rowType = rel.getRowType();
                List columns = (List)rowType.getFieldList().stream().map(field -> new ConnectorViewDefinition.ViewColumn(field.getName(), this.typeManager.fromSqlType(this.getTypeString(field.getType())).getTypeId())).collect(ImmutableList.toImmutableList());
                return new ConnectorViewDefinition(trinoSql, Optional.of(catalogName.toString()), Optional.of(table.getDatabaseName()), columns, Optional.ofNullable(table.getParameters().get("comment")), Optional.empty(), this.hiveViewsRunAsInvoker);
            }
            catch (RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_VIEW_TRANSLATION_ERROR, String.format("Failed to translate Hive view '%s': %s", table.getSchemaTableName(), e.getMessage()), (Throwable)e);
            }
        }

        private String getTypeString(RelDataType type) {
            switch (type.getSqlTypeName()) {
                case ROW: {
                    Verify.verify((boolean)type.isStruct(), (String)"expected ROW type to be a struct: %s", (Object)type);
                    return type.getFieldList().stream().map(field -> TrinoKeywordsConverter.quoteWordIfNotQuoted((String)field.getName().toLowerCase(Locale.ENGLISH)) + " " + this.getTypeString(field.getType())).collect(Collectors.joining(",", "row(", ")"));
                }
                case CHAR: {
                    return "varchar";
                }
                case FLOAT: {
                    return "real";
                }
                case BINARY: 
                case VARBINARY: {
                    return "varbinary";
                }
                case MAP: {
                    RelDataType keyType = type.getKeyType();
                    RelDataType valueType = type.getValueType();
                    return String.format("map(%s,%s)", this.getTypeString(keyType), this.getTypeString(valueType));
                }
                case ARRAY: {
                    return String.format("array(%s)", this.getTypeString(type.getComponentType()));
                }
                case DECIMAL: {
                    return String.format("decimal(%s,%s)", type.getPrecision(), type.getScale());
                }
            }
            return type.getSqlTypeName().toString();
        }
    }

    public static interface ViewReader {
        public ConnectorViewDefinition decodeViewData(String var1, Table var2, CatalogName var3);
    }
}

