/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public final class ThriftMetastoreUtil {
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String ADMIN_ROLE_NAME = "admin";
    private static final String NUM_FILES = "numFiles";
    public static final String NUM_ROWS = "numRows";
    private static final String RAW_DATA_SIZE = "rawDataSize";
    private static final String TOTAL_SIZE = "totalSize";
    private static final Set<String> STATS_PROPERTIES = ImmutableSet.of((Object)"numFiles", (Object)"numRows", (Object)"rawDataSize", (Object)"totalSize");

    private ThriftMetastoreUtil() {
    }

    public static org.apache.hadoop.hive.metastore.api.Database toMetastoreApiDatabase(Database database) {
        org.apache.hadoop.hive.metastore.api.Database result = new org.apache.hadoop.hive.metastore.api.Database();
        result.setName(database.getDatabaseName());
        database.getLocation().ifPresent(arg_0 -> ((org.apache.hadoop.hive.metastore.api.Database)result).setLocationUri(arg_0));
        result.setOwnerName((String)database.getOwnerName().orElse(null));
        result.setOwnerType((org.apache.hadoop.hive.metastore.api.PrincipalType)database.getOwnerType().map(ThriftMetastoreUtil::fromTrinoPrincipalType).orElse(null));
        database.getComment().ifPresent(arg_0 -> ((org.apache.hadoop.hive.metastore.api.Database)result).setDescription(arg_0));
        result.setParameters(database.getParameters());
        return result;
    }

    public static org.apache.hadoop.hive.metastore.api.Table toMetastoreApiTable(Table table, PrincipalPrivileges privileges) {
        org.apache.hadoop.hive.metastore.api.Table result = ThriftMetastoreUtil.toMetastoreApiTable(table);
        result.setPrivileges(ThriftMetastoreUtil.toMetastoreApiPrincipalPrivilegeSet(privileges));
        return result;
    }

    public static org.apache.hadoop.hive.metastore.api.Table toMetastoreApiTable(Table table) {
        org.apache.hadoop.hive.metastore.api.Table result = new org.apache.hadoop.hive.metastore.api.Table();
        result.setDbName(table.getDatabaseName());
        result.setTableName(table.getTableName());
        result.setOwner((String)table.getOwner().orElse(null));
        result.setTableType(table.getTableType());
        result.setParameters(table.getParameters());
        result.setPartitionKeys((List)table.getPartitionColumns().stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList()));
        result.setSd(ThriftMetastoreUtil.makeStorageDescriptor(table.getTableName(), table.getDataColumns(), table.getStorage()));
        result.setViewOriginalText((String)table.getViewOriginalText().orElse(null));
        result.setViewExpandedText((String)table.getViewExpandedText().orElse(null));
        table.getWriteId().ifPresent(arg_0 -> ((org.apache.hadoop.hive.metastore.api.Table)result).setWriteId(arg_0));
        return result;
    }

    private static PrincipalPrivilegeSet toMetastoreApiPrincipalPrivilegeSet(PrincipalPrivileges privileges) {
        ImmutableMap.Builder userPrivileges = ImmutableMap.builder();
        for (Map.Entry entry : privileges.getUserPrivileges().asMap().entrySet()) {
            userPrivileges.put((Object)((String)entry.getKey()), (Object)((List)((Collection)entry.getValue()).stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(ImmutableList.toImmutableList())));
        }
        ImmutableMap.Builder rolePrivileges = ImmutableMap.builder();
        for (Map.Entry entry : privileges.getRolePrivileges().asMap().entrySet()) {
            rolePrivileges.put((Object)((String)entry.getKey()), (Object)((List)((Collection)entry.getValue()).stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(ImmutableList.toImmutableList())));
        }
        return new PrincipalPrivilegeSet((Map)userPrivileges.buildOrThrow(), (Map)ImmutableMap.of(), (Map)rolePrivileges.buildOrThrow());
    }

    public static PrivilegeGrantInfo toMetastoreApiPrivilegeGrantInfo(HivePrivilegeInfo privilegeInfo) {
        return new PrivilegeGrantInfo(privilegeInfo.getHivePrivilege().name().toLowerCase(Locale.ENGLISH), 0, privilegeInfo.getGrantor().getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(privilegeInfo.getGrantor().getType()), privilegeInfo.isGrantOption());
    }

    public static Stream<RoleGrant> listApplicableRoles(final HivePrincipal principal, final Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        return Streams.stream((Iterator)new AbstractIterator<RoleGrant>(){
            private final Queue<RoleGrant> output = new ArrayDeque<RoleGrant>();
            private final Set<RoleGrant> seenRoles = new HashSet<RoleGrant>();
            private final Queue<HivePrincipal> queue = new ArrayDeque<HivePrincipal>();
            {
                this.queue.add(principal);
            }

            protected RoleGrant computeNext() {
                while (this.output.isEmpty() && !this.queue.isEmpty()) {
                    Set grants = (Set)listRoleGrants.apply(this.queue.remove());
                    for (RoleGrant grant : grants) {
                        if (!this.seenRoles.add(grant)) continue;
                        this.output.add(grant);
                        this.queue.add(new HivePrincipal(PrincipalType.ROLE, grant.getRoleName()));
                    }
                }
                if (!this.output.isEmpty()) {
                    return this.output.remove();
                }
                return (RoleGrant)this.endOfData();
            }
        });
    }

    public static boolean isRoleApplicable(HivePrincipal principal, String role, Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        if (principal.getType() == PrincipalType.ROLE && principal.getName().equals(role)) {
            return true;
        }
        return ThriftMetastoreUtil.listApplicableRoleNames(principal, listRoleGrants).anyMatch(role::equals);
    }

    private static Stream<String> listApplicableRoleNames(HivePrincipal principal, Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        return ThriftMetastoreUtil.listApplicableRoles(principal, listRoleGrants).map(RoleGrant::getRoleName);
    }

    public static Stream<HivePrincipal> listEnabledPrincipals(ConnectorIdentity identity, Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        return Stream.concat(Stream.of(new HivePrincipal(PrincipalType.USER, identity.getUser())), ThriftMetastoreUtil.listEnabledRoles(identity, listRoleGrants).map(role -> new HivePrincipal(PrincipalType.ROLE, (String)role)));
    }

    public static boolean isRoleEnabled(ConnectorIdentity identity, Function<HivePrincipal, Set<RoleGrant>> listRoleGrants, String role) {
        if (role.equals(PUBLIC_ROLE_NAME)) {
            return true;
        }
        if (identity.getConnectorRole().isPresent() && ((SelectedRole)identity.getConnectorRole().get()).getType() == SelectedRole.Type.NONE) {
            return false;
        }
        HivePrincipal principal = HivePrincipal.from(identity);
        if (principal.getType() == PrincipalType.ROLE && principal.getName().equals(role)) {
            return true;
        }
        if (role.equals(ADMIN_ROLE_NAME)) {
            return false;
        }
        return ThriftMetastoreUtil.listEnabledRoles(identity, listRoleGrants).anyMatch(role::equals);
    }

    public static Stream<String> listEnabledRoles(ConnectorIdentity identity, Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        if (identity.getConnectorRole().isPresent() && ((SelectedRole)identity.getConnectorRole().get()).getType() == SelectedRole.Type.NONE) {
            return Stream.of(PUBLIC_ROLE_NAME);
        }
        HivePrincipal principal = HivePrincipal.from(identity);
        Stream<String> roles = Stream.of(PUBLIC_ROLE_NAME);
        if (principal.getType() == PrincipalType.ROLE) {
            roles = Stream.concat(roles, Stream.of(principal.getName()));
        }
        return Stream.concat(roles, ThriftMetastoreUtil.listApplicableRoles(principal, listRoleGrants).map(RoleGrant::getRoleName).filter(Predicate.isEqual(ADMIN_ROLE_NAME).negate())).distinct();
    }

    public static org.apache.hadoop.hive.metastore.api.Partition toMetastoreApiPartition(PartitionWithStatistics partitionWithStatistics) {
        org.apache.hadoop.hive.metastore.api.Partition partition = ThriftMetastoreUtil.toMetastoreApiPartition(partitionWithStatistics.getPartition());
        partition.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(partition.getParameters(), partitionWithStatistics.getStatistics().getBasicStatistics()));
        return partition;
    }

    public static org.apache.hadoop.hive.metastore.api.Partition toMetastoreApiPartition(Partition partition) {
        return ThriftMetastoreUtil.toMetastoreApiPartition(partition, Optional.empty());
    }

    public static org.apache.hadoop.hive.metastore.api.Partition toMetastoreApiPartition(Partition partition, Optional<Long> writeId) {
        org.apache.hadoop.hive.metastore.api.Partition result = new org.apache.hadoop.hive.metastore.api.Partition();
        result.setDbName(partition.getDatabaseName());
        result.setTableName(partition.getTableName());
        result.setValues(partition.getValues());
        result.setSd(ThriftMetastoreUtil.makeStorageDescriptor(partition.getTableName(), partition.getColumns(), partition.getStorage()));
        result.setParameters(partition.getParameters());
        writeId.ifPresent(arg_0 -> ((org.apache.hadoop.hive.metastore.api.Partition)result).setWriteId(arg_0));
        return result;
    }

    public static Database fromMetastoreApiDatabase(org.apache.hadoop.hive.metastore.api.Database database) {
        Map parameters;
        String ownerName = "PUBLIC";
        PrincipalType ownerType = PrincipalType.ROLE;
        if (database.getOwnerName() != null) {
            ownerName = database.getOwnerName();
            ownerType = ThriftMetastoreUtil.fromMetastoreApiPrincipalType(database.getOwnerType());
        }
        if ((parameters = database.getParameters()) == null) {
            parameters = ImmutableMap.of();
        }
        return Database.builder().setDatabaseName(database.getName()).setLocation(Optional.ofNullable(database.getLocationUri())).setOwnerName(Optional.of(ownerName)).setOwnerType(Optional.of(ownerType)).setComment(Optional.ofNullable(database.getDescription())).setParameters(parameters).build();
    }

    public static Table fromMetastoreApiTable(org.apache.hadoop.hive.metastore.api.Table table) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        return ThriftMetastoreUtil.fromMetastoreApiTable(table, storageDescriptor.getCols());
    }

    public static Table fromMetastoreApiTable(org.apache.hadoop.hive.metastore.api.Table table, List<FieldSchema> schema) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(table.getDbName()).setTableName(table.getTableName()).setOwner(Optional.ofNullable(table.getOwner())).setTableType(table.getTableType()).setDataColumns((List)schema.stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList())).setPartitionColumns((List)table.getPartitionKeys().stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList())).setParameters((Map<String, String>)(table.getParameters() == null ? ImmutableMap.of() : table.getParameters())).setViewOriginalText(Optional.ofNullable(Strings.emptyToNull((String)table.getViewOriginalText()))).setViewExpandedText(Optional.ofNullable(Strings.emptyToNull((String)table.getViewExpandedText()))).setWriteId(table.getWriteId() < 0L ? OptionalLong.empty() : OptionalLong.of(table.getWriteId()));
        ThriftMetastoreUtil.fromMetastoreApiStorageDescriptor(table.getParameters(), storageDescriptor, tableBuilder.getStorageBuilder(), table.getTableName());
        return tableBuilder.build();
    }

    public static boolean isAvroTableWithSchemaSet(org.apache.hadoop.hive.metastore.api.Table table) {
        if (table.getParameters() == null) {
            return false;
        }
        SerDeInfo serdeInfo = ThriftMetastoreUtil.getSerdeInfo(table);
        return serdeInfo.getSerializationLib() != null && (table.getParameters().get("avro.schema.url") != null || serdeInfo.getParameters() != null && serdeInfo.getParameters().get("avro.schema.url") != null || table.getParameters().get("avro.schema.literal") != null || serdeInfo.getParameters() != null && serdeInfo.getParameters().get("avro.schema.literal") != null) && serdeInfo.getSerializationLib().equals(HiveStorageFormat.AVRO.getSerde());
    }

    public static boolean isCsvTable(org.apache.hadoop.hive.metastore.api.Table table) {
        return HiveStorageFormat.CSV.getSerde().equals(ThriftMetastoreUtil.getSerdeInfo(table).getSerializationLib());
    }

    public static List<FieldSchema> csvSchemaFields(List<FieldSchema> schemas) {
        return (List)schemas.stream().map(schema -> new FieldSchema(schema.getName(), HiveType.HIVE_STRING.toString(), schema.getComment())).collect(ImmutableList.toImmutableList());
    }

    private static SerDeInfo getSerdeInfo(org.apache.hadoop.hive.metastore.api.Table table) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table does not contain a storage descriptor: " + table);
        }
        SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        return serdeInfo;
    }

    public static Partition fromMetastoreApiPartition(org.apache.hadoop.hive.metastore.api.Partition partition) {
        StorageDescriptor storageDescriptor = partition.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Partition does not contain a storage descriptor: " + partition);
        }
        return ThriftMetastoreUtil.fromMetastoreApiPartition(partition, storageDescriptor.getCols());
    }

    public static Partition fromMetastoreApiPartition(org.apache.hadoop.hive.metastore.api.Partition partition, List<FieldSchema> schema) {
        StorageDescriptor storageDescriptor = partition.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Partition does not contain a storage descriptor: " + partition);
        }
        Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(partition.getDbName()).setTableName(partition.getTableName()).setValues(partition.getValues()).setColumns((List)schema.stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList())).setParameters(partition.getParameters());
        ThriftMetastoreUtil.fromMetastoreApiStorageDescriptor(partition.getParameters(), storageDescriptor, partitionBuilder.getStorageBuilder(), String.format("%s.%s", partition.getTableName(), partition.getValues()));
        return partitionBuilder.build();
    }

    public static HiveColumnStatistics fromMetastoreApiColumnStatistics(ColumnStatisticsObj columnStatistics, OptionalLong rowCount) {
        if (columnStatistics.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStatsData = columnStatistics.getStatsData().getLongStats();
            OptionalLong min = longStatsData.isSetLowValue() ? OptionalLong.of(longStatsData.getLowValue()) : OptionalLong.empty();
            OptionalLong max = longStatsData.isSetHighValue() ? OptionalLong.of(longStatsData.getHighValue()) : OptionalLong.empty();
            OptionalLong nullsCount = longStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(longStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = longStatsData.isSetNumDVs() ? OptionalLong.of(longStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createIntegerColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStatsData = columnStatistics.getStatsData().getDoubleStats();
            OptionalDouble min = doubleStatsData.isSetLowValue() ? OptionalDouble.of(doubleStatsData.getLowValue()) : OptionalDouble.empty();
            OptionalDouble max = doubleStatsData.isSetHighValue() ? OptionalDouble.of(doubleStatsData.getHighValue()) : OptionalDouble.empty();
            OptionalLong nullsCount = doubleStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(doubleStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = doubleStatsData.isSetNumDVs() ? OptionalLong.of(doubleStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDoubleColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStatsData = columnStatistics.getStatsData().getDecimalStats();
            Optional<BigDecimal> min = decimalStatsData.isSetLowValue() ? ThriftMetastoreUtil.fromMetastoreDecimal(decimalStatsData.getLowValue()) : Optional.empty();
            Optional<BigDecimal> max = decimalStatsData.isSetHighValue() ? ThriftMetastoreUtil.fromMetastoreDecimal(decimalStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = decimalStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(decimalStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = decimalStatsData.isSetNumDVs() ? OptionalLong.of(decimalStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDecimalColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetDateStats()) {
            DateColumnStatsData dateStatsData = columnStatistics.getStatsData().getDateStats();
            Optional<LocalDate> min = dateStatsData.isSetLowValue() ? ThriftMetastoreUtil.fromMetastoreDate(dateStatsData.getLowValue()) : Optional.empty();
            Optional<LocalDate> max = dateStatsData.isSetHighValue() ? ThriftMetastoreUtil.fromMetastoreDate(dateStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = dateStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(dateStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = dateStatsData.isSetNumDVs() ? OptionalLong.of(dateStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDateColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData booleanStatsData = columnStatistics.getStatsData().getBooleanStats();
            OptionalLong trueCount = OptionalLong.empty();
            OptionalLong falseCount = OptionalLong.empty();
            if (booleanStatsData.isSetNumTrues() && booleanStatsData.isSetNumFalses() && booleanStatsData.getNumFalses() != -1L) {
                trueCount = OptionalLong.of(booleanStatsData.getNumTrues());
                falseCount = OptionalLong.of(booleanStatsData.getNumFalses());
            }
            return HiveColumnStatistics.createBooleanColumnStatistics(trueCount, falseCount, booleanStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(booleanStatsData.getNumNulls()) : OptionalLong.empty());
        }
        if (columnStatistics.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStatsData = columnStatistics.getStatsData().getStringStats();
            OptionalLong maxColumnLength = stringStatsData.isSetMaxColLen() ? OptionalLong.of(stringStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = stringStatsData.isSetAvgColLen() ? OptionalDouble.of(stringStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = stringStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(stringStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = stringStatsData.isSetNumDVs() ? OptionalLong.of(stringStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createStringColumnStatistics(maxColumnLength, ThriftMetastoreUtil.getTotalSizeInBytes(averageColumnLength, rowCount, nullsCount), nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStatsData = columnStatistics.getStatsData().getBinaryStats();
            OptionalLong maxColumnLength = binaryStatsData.isSetMaxColLen() ? OptionalLong.of(binaryStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = binaryStatsData.isSetAvgColLen() ? OptionalDouble.of(binaryStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = binaryStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(binaryStatsData.getNumNulls()) : OptionalLong.empty();
            return HiveColumnStatistics.createBinaryColumnStatistics(maxColumnLength, ThriftMetastoreUtil.getTotalSizeInBytes(averageColumnLength, rowCount, nullsCount), nullsCount);
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Invalid column statistics data: " + columnStatistics);
    }

    private static Optional<LocalDate> fromMetastoreDate(Date date) {
        if (date == null) {
            return Optional.empty();
        }
        return Optional.of(LocalDate.ofEpochDay(date.getDaysSinceEpoch()));
    }

    public static OptionalLong fromMetastoreNullsCount(long nullsCount) {
        if (nullsCount == -1L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(nullsCount);
    }

    private static Optional<BigDecimal> fromMetastoreDecimal(@Nullable Decimal decimal) {
        if (decimal == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(new BigInteger(decimal.getUnscaled()), decimal.getScale()));
    }

    public static OptionalLong getTotalSizeInBytes(OptionalDouble averageColumnLength, OptionalLong rowCount, OptionalLong nullsCount) {
        if (averageColumnLength.isPresent() && rowCount.isPresent() && nullsCount.isPresent()) {
            long nonNullsCount = rowCount.getAsLong() - nullsCount.getAsLong();
            if (nonNullsCount < 0L) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(Math.round(averageColumnLength.getAsDouble() * (double)nonNullsCount));
        }
        return OptionalLong.empty();
    }

    public static OptionalLong fromMetastoreDistinctValuesCount(OptionalLong distinctValuesCount, OptionalLong nullsCount, OptionalLong rowCount) {
        if (distinctValuesCount.isPresent() && nullsCount.isPresent() && rowCount.isPresent()) {
            return OptionalLong.of(ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount.getAsLong(), nullsCount.getAsLong(), rowCount.getAsLong()));
        }
        return OptionalLong.empty();
    }

    private static long fromMetastoreDistinctValuesCount(long distinctValuesCount, long nullsCount, long rowCount) {
        long nonNullsCount = rowCount - nullsCount;
        if (nullsCount > 0L && distinctValuesCount > 0L) {
            --distinctValuesCount;
        }
        if (nonNullsCount > 0L && distinctValuesCount == 0L) {
            distinctValuesCount = 1L;
        }
        return Math.min(distinctValuesCount, nonNullsCount);
    }

    public static Set<RoleGrant> fromRolePrincipalGrants(Collection<RolePrincipalGrant> grants) {
        return (Set)grants.stream().map(ThriftMetastoreUtil::fromRolePrincipalGrant).collect(ImmutableSet.toImmutableSet());
    }

    private static RoleGrant fromRolePrincipalGrant(RolePrincipalGrant grant) {
        return new RoleGrant(new TrinoPrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(grant.getPrincipalType()), grant.getPrincipalName()), grant.getRoleName(), grant.isGrantOption());
    }

    public static org.apache.hadoop.hive.metastore.api.PrincipalType fromTrinoPrincipalType(PrincipalType principalType) {
        return switch (principalType) {
            default -> throw new IncompatibleClassChangeError();
            case PrincipalType.USER -> org.apache.hadoop.hive.metastore.api.PrincipalType.USER;
            case PrincipalType.ROLE -> org.apache.hadoop.hive.metastore.api.PrincipalType.ROLE;
        };
    }

    public static PrincipalType fromMetastoreApiPrincipalType(org.apache.hadoop.hive.metastore.api.PrincipalType principalType) {
        Objects.requireNonNull(principalType, "principalType is null");
        switch (principalType) {
            case USER: {
                return PrincipalType.USER;
            }
            case ROLE: {
                return PrincipalType.ROLE;
            }
        }
        throw new IllegalArgumentException("Unsupported principal type: " + principalType);
    }

    public static FieldSchema toMetastoreApiFieldSchema(Column column) {
        return new FieldSchema(column.getName(), column.getType().getHiveTypeName().toString(), (String)column.getComment().orElse(null));
    }

    private static Column fromMetastoreApiFieldSchema(FieldSchema fieldSchema) {
        return new Column(fieldSchema.getName(), HiveType.valueOf(fieldSchema.getType()), Optional.ofNullable(fieldSchema.getComment()));
    }

    private static void fromMetastoreApiStorageDescriptor(Map<String, String> tableParameters, StorageDescriptor storageDescriptor, Storage.Builder builder, String tablePartitionName) {
        SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        builder.setStorageFormat(StorageFormat.createNullable(serdeInfo.getSerializationLib(), storageDescriptor.getInputFormat(), storageDescriptor.getOutputFormat())).setLocation(Strings.nullToEmpty((String)storageDescriptor.getLocation())).setBucketProperty(HiveBucketProperty.fromStorageDescriptor(tableParameters, storageDescriptor, tablePartitionName)).setSkewed(storageDescriptor.isSetSkewedInfo() && storageDescriptor.getSkewedInfo().isSetSkewedColNames() && !storageDescriptor.getSkewedInfo().getSkewedColNames().isEmpty()).setSerdeParameters((Map<String, String>)(serdeInfo.getParameters() == null ? ImmutableMap.of() : serdeInfo.getParameters()));
    }

    private static StorageDescriptor makeStorageDescriptor(String tableName, List<Column> columns, Storage storage) {
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(tableName);
        serdeInfo.setSerializationLib(storage.getStorageFormat().getSerDeNullable());
        serdeInfo.setParameters(storage.getSerdeParameters());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(Strings.emptyToNull((String)storage.getOptionalLocation().orElse(null)));
        sd.setCols((List)columns.stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList()));
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(storage.getStorageFormat().getInputFormatNullable());
        sd.setOutputFormat(storage.getStorageFormat().getOutputFormatNullable());
        sd.setSkewedInfoIsSet(storage.isSkewed());
        sd.setParameters((Map)ImmutableMap.of());
        Optional<HiveBucketProperty> bucketProperty = storage.getBucketProperty();
        if (bucketProperty.isPresent()) {
            sd.setNumBuckets(bucketProperty.get().getBucketCount());
            sd.setBucketCols(bucketProperty.get().getBucketedBy());
            if (!bucketProperty.get().getSortedBy().isEmpty()) {
                sd.setSortCols((List)bucketProperty.get().getSortedBy().stream().map(column -> new Order(column.getColumnName(), column.getOrder().getHiveOrder())).collect(ImmutableList.toImmutableList()));
            }
        }
        return sd;
    }

    public static Set<HivePrivilegeInfo> parsePrivilege(PrivilegeGrantInfo userGrant, Optional<HivePrincipal> grantee) {
        boolean grantOption = userGrant.isGrantOption();
        String name = userGrant.getPrivilege().toUpperCase(Locale.ENGLISH);
        HivePrincipal grantor = new HivePrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(userGrant.getGrantorType()), userGrant.getGrantor());
        return switch (name) {
            case "ALL" -> (ImmutableSet)Arrays.stream(HivePrivilegeInfo.HivePrivilege.values()).map(hivePrivilege -> new HivePrivilegeInfo((HivePrivilegeInfo.HivePrivilege)((Object)hivePrivilege), grantOption, grantor, grantee.orElse(grantor))).collect(ImmutableSet.toImmutableSet());
            case "SELECT" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, grantOption, grantor, grantee.orElse(grantor)));
            case "INSERT" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, grantOption, grantor, grantee.orElse(grantor)));
            case "UPDATE" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, grantOption, grantor, grantee.orElse(grantor)));
            case "DELETE" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, grantOption, grantor, grantee.orElse(grantor)));
            case "OWNERSHIP" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, grantOption, grantor, grantee.orElse(grantor)));
            default -> throw new IllegalArgumentException("Unsupported privilege name: " + name);
        };
    }

    public static HiveBasicStatistics getHiveBasicStatistics(Map<String, String> parameters) {
        OptionalLong numFiles = ThriftMetastoreUtil.parse(parameters.get(NUM_FILES));
        OptionalLong numRows = ThriftMetastoreUtil.parse(parameters.get(NUM_ROWS));
        OptionalLong inMemoryDataSizeInBytes = ThriftMetastoreUtil.parse(parameters.get(RAW_DATA_SIZE));
        OptionalLong onDiskDataSizeInBytes = ThriftMetastoreUtil.parse(parameters.get(TOTAL_SIZE));
        return new HiveBasicStatistics(numFiles, numRows, inMemoryDataSizeInBytes, onDiskDataSizeInBytes);
    }

    private static OptionalLong parse(@Nullable String parameterValue) {
        if (parameterValue == null) {
            return OptionalLong.empty();
        }
        Long longValue = Longs.tryParse((String)parameterValue);
        if (longValue == null || longValue < 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(longValue);
    }

    public static Map<String, String> updateStatisticsParameters(Map<String, String> parameters, HiveBasicStatistics statistics) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        parameters.forEach((key, value) -> {
            if (!STATS_PROPERTIES.contains(key)) {
                result.put(key, value);
            }
        });
        statistics.getFileCount().ifPresent(count -> result.put((Object)NUM_FILES, (Object)Long.toString(count)));
        statistics.getRowCount().ifPresent(count -> result.put((Object)NUM_ROWS, (Object)Long.toString(count)));
        statistics.getInMemoryDataSizeInBytes().ifPresent(size -> result.put((Object)RAW_DATA_SIZE, (Object)Long.toString(size)));
        statistics.getOnDiskDataSizeInBytes().ifPresent(size -> result.put((Object)TOTAL_SIZE, (Object)Long.toString(size)));
        if (!parameters.containsKey("STATS_GENERATED_VIA_STATS_TASK")) {
            result.put((Object)"STATS_GENERATED_VIA_STATS_TASK", (Object)"workaround for potential lack of HIVE-12730");
        }
        return result.buildOrThrow();
    }

    public static ColumnStatisticsObj createMetastoreColumnStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics, OptionalLong rowCount) {
        TypeInfo typeInfo = columnType.getTypeInfo();
        Preconditions.checkArgument((typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE ? 1 : 0) != 0, (String)"unsupported type: %s", (Object)columnType);
        switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            case BOOLEAN: {
                return ThriftMetastoreUtil.createBooleanStatistics(columnName, columnType, statistics);
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case TIMESTAMP: {
                return ThriftMetastoreUtil.createLongStatistics(columnName, columnType, statistics);
            }
            case FLOAT: 
            case DOUBLE: {
                return ThriftMetastoreUtil.createDoubleStatistics(columnName, columnType, statistics);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return ThriftMetastoreUtil.createStringStatistics(columnName, columnType, statistics, rowCount);
            }
            case DATE: {
                return ThriftMetastoreUtil.createDateStatistics(columnName, columnType, statistics);
            }
            case BINARY: {
                return ThriftMetastoreUtil.createBinaryStatistics(columnName, columnType, statistics, rowCount);
            }
            case DECIMAL: {
                return ThriftMetastoreUtil.createDecimalStatistics(columnName, columnType, statistics);
            }
        }
        throw new IllegalArgumentException(String.format("unsupported type: %s", columnType));
    }

    private static ColumnStatisticsObj createBooleanStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        BooleanColumnStatsData data = new BooleanColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumNulls(arg_0));
        statistics.getBooleanStatistics().ifPresent(booleanStatistics -> {
            booleanStatistics.getFalseCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumFalses(arg_0));
            booleanStatistics.getTrueCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumTrues(arg_0));
        });
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.booleanStats((BooleanColumnStatsData)data));
    }

    private static ColumnStatisticsObj createLongStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        LongColumnStatsData data = new LongColumnStatsData();
        statistics.getIntegerStatistics().ifPresent(integerStatistics -> {
            integerStatistics.getMin().ifPresent(arg_0 -> ((LongColumnStatsData)data).setLowValue(arg_0));
            integerStatistics.getMax().ifPresent(arg_0 -> ((LongColumnStatsData)data).setHighValue(arg_0));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((LongColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((LongColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.longStats((LongColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDoubleStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DoubleColumnStatsData data = new DoubleColumnStatsData();
        statistics.getDoubleStatistics().ifPresent(doubleStatistics -> {
            doubleStatistics.getMin().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setLowValue(arg_0));
            doubleStatistics.getMax().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setHighValue(arg_0));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.doubleStats((DoubleColumnStatsData)data));
    }

    private static ColumnStatisticsObj createStringStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics, OptionalLong rowCount) {
        StringColumnStatsData data = new StringColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((StringColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((StringColumnStatsData)data).setNumDVs(arg_0));
        data.setMaxColLen(statistics.getMaxValueSizeInBytes().orElse(0L));
        data.setAvgColLen(ThriftMetastoreUtil.getAverageColumnLength(statistics.getTotalSizeInBytes(), rowCount, statistics.getNullsCount()).orElse(0.0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.stringStats((StringColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDateStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DateColumnStatsData data = new DateColumnStatsData();
        statistics.getDateStatistics().ifPresent(dateStatistics -> {
            dateStatistics.getMin().ifPresent(value -> data.setLowValue(ThriftMetastoreUtil.toMetastoreDate(value)));
            dateStatistics.getMax().ifPresent(value -> data.setHighValue(ThriftMetastoreUtil.toMetastoreDate(value)));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DateColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DateColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.dateStats((DateColumnStatsData)data));
    }

    private static ColumnStatisticsObj createBinaryStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics, OptionalLong rowCount) {
        BinaryColumnStatsData data = new BinaryColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((BinaryColumnStatsData)data).setNumNulls(arg_0));
        data.setMaxColLen(statistics.getMaxValueSizeInBytes().orElse(0L));
        data.setAvgColLen(ThriftMetastoreUtil.getAverageColumnLength(statistics.getTotalSizeInBytes(), rowCount, statistics.getNullsCount()).orElse(0.0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.binaryStats((BinaryColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDecimalStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DecimalColumnStatsData data = new DecimalColumnStatsData();
        statistics.getDecimalStatistics().ifPresent(decimalStatistics -> {
            decimalStatistics.getMin().ifPresent(value -> data.setLowValue(ThriftMetastoreUtil.toMetastoreDecimal(value)));
            decimalStatistics.getMax().ifPresent(value -> data.setHighValue(ThriftMetastoreUtil.toMetastoreDecimal(value)));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DecimalColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DecimalColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.decimalStats((DecimalColumnStatsData)data));
    }

    private static Date toMetastoreDate(LocalDate date) {
        return new Date(date.toEpochDay());
    }

    public static Decimal toMetastoreDecimal(BigDecimal decimal) {
        return new Decimal(Shorts.checkedCast((long)decimal.scale()), ByteBuffer.wrap(decimal.unscaledValue().toByteArray()));
    }

    public static OptionalLong toMetastoreDistinctValuesCount(OptionalLong distinctValuesCount, OptionalLong nullsCount) {
        if (distinctValuesCount.isPresent() && nullsCount.isPresent()) {
            return OptionalLong.of(distinctValuesCount.getAsLong() + (long)(nullsCount.getAsLong() > 0L ? 1 : 0));
        }
        return OptionalLong.empty();
    }

    public static OptionalDouble getAverageColumnLength(OptionalLong totalSizeInBytes, OptionalLong rowCount, OptionalLong nullsCount) {
        if (totalSizeInBytes.isPresent() && rowCount.isPresent() && nullsCount.isPresent()) {
            long nonNullsCount = rowCount.getAsLong() - nullsCount.getAsLong();
            if (nonNullsCount <= 0L) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of((double)totalSizeInBytes.getAsLong() / (double)nonNullsCount);
        }
        return OptionalDouble.empty();
    }

    public static Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_TRUE_VALUES));
        }
        if (ThriftMetastoreUtil.isNumericType(type) || type.equals(DateType.DATE)) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.MIN_VALUE), (Object)((Object)HiveColumnStatisticType.MAX_VALUE), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES));
        }
        if (type instanceof TimestampType) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES));
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), (Object)((Object)HiveColumnStatisticType.TOTAL_SIZE_IN_BYTES), (Object)((Object)HiveColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES));
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), (Object)((Object)HiveColumnStatisticType.TOTAL_SIZE_IN_BYTES), (Object)((Object)HiveColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES));
        }
        if (type instanceof ArrayType || type instanceof RowType || type instanceof MapType) {
            return ImmutableSet.of();
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private static boolean isNumericType(Type type) {
        return type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type instanceof DecimalType;
    }
}

