/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Random;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.UnsafeUtil;

public final class Util {
    private static final String LS = System.getProperty("line.separator");

    private Util() {
    }

    public static long binarySearchLongs(Memory mem, long fromLongIndex, long toLongIndex, long key) {
        UnsafeUtil.checkBounds(fromLongIndex << 3, toLongIndex - fromLongIndex << 3, mem.getCapacity());
        long low = fromLongIndex;
        long high = toLongIndex - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            long midVal = mem.getLong(mid << 3);
            if (midVal < key) {
                low = mid + 1L;
                continue;
            }
            if (midVal > key) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public static final String zeroPad(String s, int fieldLength) {
        return Util.characterPad(s, fieldLength, '0', false);
    }

    public static final String characterPad(String s, int fieldLength, char padChar, boolean postpend) {
        char[] chArr = s.toCharArray();
        int sLen = chArr.length;
        if (sLen < fieldLength) {
            char[] out = new char[fieldLength];
            int blanks = fieldLength - sLen;
            if (postpend) {
                int i;
                for (i = 0; i < sLen; ++i) {
                    out[i] = chArr[i];
                }
                for (i = sLen; i < fieldLength; ++i) {
                    out[i] = padChar;
                }
            } else {
                int i;
                for (i = 0; i < blanks; ++i) {
                    out[i] = padChar;
                }
                for (i = blanks; i < fieldLength; ++i) {
                    out[i] = chArr[i - blanks];
                }
            }
            return String.valueOf(out);
        }
        return s;
    }

    public static final boolean isAllBitsClear(long value, long bitMask) {
        return ((value ^ 0xFFFFFFFFFFFFFFFFL) & bitMask) == bitMask;
    }

    public static final boolean isAllBitsSet(long value, long bitMask) {
        return (value & bitMask) == bitMask;
    }

    public static final boolean isAnyBitsClear(long value, long bitMask) {
        return ((value ^ 0xFFFFFFFFFFFFFFFFL) & bitMask) != 0L;
    }

    public static final boolean isAnyBitsSet(long value, long bitMask) {
        return (value & bitMask) != 0L;
    }

    static final void zeroCheck(long value, String arg) {
        if (value <= 0L) {
            throw new IllegalArgumentException("The argument " + arg + " may not be negative or zero.");
        }
    }

    static final void negativeCheck(long value, String arg) {
        if (value < 0L) {
            throw new IllegalArgumentException("The argument " + arg + " may not be negative.");
        }
    }

    static final void nullCheck(Object obj, String arg) {
        if (obj == null) {
            throw new IllegalArgumentException("The argument " + arg + " may not be null.");
        }
    }

    public static String getResourcePath(String shortFileName) {
        try {
            URL url = Util.class.getClassLoader().getResource(shortFileName);
            URI uri = url.toURI();
            String path = uri.getPath();
            return path;
        }
        catch (NullPointerException | URISyntaxException e) {
            throw new IllegalArgumentException("Cannot find resource: " + shortFileName + LS + e);
        }
    }

    public static File getResourceFile(String shortFileName) {
        return new File(Util.getResourcePath(shortFileName));
    }

    public static byte[] getResourceBytes(String shortFileName) {
        try {
            return Files.readAllBytes(Paths.get(Util.getResourcePath(shortFileName), new String[0]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read resource: " + shortFileName + LS + e);
        }
    }

    public static class RandomCodePoints {
        private Random rand;
        private static final int ALL_CP = 0x110000;
        private static final int MIN_SUR = 55296;
        private static final int MAX_SUR = 57343;

        public RandomCodePoints(boolean deterministic) {
            this.rand = deterministic ? new Random(0L) : new Random();
        }

        public final void fillCodePointArray(int[] cpArr) {
            this.fillCodePointArray(cpArr, 0, 0x110000);
        }

        public final void fillCodePointArray(int[] cpArr, int startCP, int endCP) {
            int arrLen = cpArr.length;
            int numCP = Math.min(endCP, 0x110000) - Math.min(0, startCP);
            int idx = 0;
            while (idx < arrLen) {
                int cp = startCP + this.rand.nextInt(numCP);
                if (cp >= 55296 && cp <= 57343) continue;
                cpArr[idx++] = cp;
            }
        }

        public final int getCodePoint() {
            return this.getCodePoint(0, 0x110000);
        }

        public final int getCodePoint(int startCP, int endCP) {
            int cp;
            int numCP = Math.min(endCP, 0x110000) - Math.min(0, startCP);
            while ((cp = startCP + this.rand.nextInt(numCP)) >= 55296 && cp <= 57343) {
            }
            return cp;
        }
    }
}

