/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class IcebergAnalyzeProperties {
    public static final String COLUMNS_PROPERTY = "columns";
    private final List<PropertyMetadata<?>> analyzeProperties = ImmutableList.builder().add((Object)new PropertyMetadata("columns", "Columns to be analyzed", (Type)new ArrayType((Type)VarcharType.VARCHAR), Set.class, null, false, IcebergAnalyzeProperties::decodeColumnNames, value -> value)).build();

    @Inject
    public IcebergAnalyzeProperties() {
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public static Optional<Set<String>> getColumnNames(Map<String, Object> properties) {
        Set columns = (Set)properties.get(COLUMNS_PROPERTY);
        return Optional.ofNullable(columns);
    }

    private static Set<String> decodeColumnNames(Object object) {
        if (object == null) {
            return null;
        }
        Collection columns = (Collection)object;
        return (Set)columns.stream().peek(property -> IcebergAnalyzeProperties.throwIfNull(property, COLUMNS_PROPERTY)).map(String.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    private static void throwIfNull(Object object, String propertyName) {
        if (object == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid null value in analyze %s property", propertyName));
        }
    }
}

