/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplitSource;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTransactionManager;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;

public class IcebergSplitManager
implements ConnectorSplitManager {
    public static final int ICEBERG_DOMAIN_COMPACTION_THRESHOLD = 1000;
    private final IcebergTransactionManager transactionManager;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public IcebergSplitManager(IcebergTransactionManager transactionManager, TypeManager typeManager, HdfsEnvironment hdfsEnvironment) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle handle, DynamicFilter dynamicFilter, Constraint constraint) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        if (table.getSnapshotId().isEmpty()) {
            if (table.isRecordScannedFiles()) {
                return new FixedSplitSource((Iterable)ImmutableList.of(), (List)ImmutableList.of());
            }
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        Table icebergTable = this.transactionManager.get(transaction, session.getIdentity()).getIcebergTable(session, table.getSchemaTableName());
        Duration dynamicFilteringWaitTimeout = IcebergSessionProperties.getDynamicFilteringWaitTimeout(session);
        TableScan tableScan = icebergTable.newScan().useSnapshot(table.getSnapshotId().get().longValue());
        IcebergSplitSource splitSource = new IcebergSplitSource(this.hdfsEnvironment, new HdfsContext(session), table, tableScan, table.getMaxScannedFileSize(), dynamicFilter, dynamicFilteringWaitTimeout, constraint, this.typeManager, table.isRecordScannedFiles(), IcebergSessionProperties.getMinimumAssignedSplitWeight(session));
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, IcebergSplitManager.class.getClassLoader());
    }
}

