/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergStatistics;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;

public class TableStatisticsMaker {
    public static final String TRINO_STATS_PREFIX = "trino.stats.ndv.";
    public static final String TRINO_STATS_NDV_FORMAT = "trino.stats.ndv.%d.ndv";
    public static final Pattern TRINO_STATS_COLUMN_ID_PATTERN = Pattern.compile(Pattern.quote("trino.stats.ndv.") + "(?<columnId>\\d+)\\..*");
    public static final Pattern TRINO_STATS_NDV_PATTERN = Pattern.compile(Pattern.quote("trino.stats.ndv.") + "(?<columnId>\\d+)\\.ndv");
    private final TypeManager typeManager;
    private final ConnectorSession session;
    private final Table icebergTable;

    private TableStatisticsMaker(TypeManager typeManager, ConnectorSession session, Table icebergTable) {
        this.typeManager = typeManager;
        this.session = session;
        this.icebergTable = icebergTable;
    }

    public static TableStatistics getTableStatistics(TypeManager typeManager, ConnectorSession session, IcebergTableHandle tableHandle, Table icebergTable) {
        return new TableStatisticsMaker(typeManager, session, icebergTable).makeTableStatistics(tableHandle);
    }

    private TableStatistics makeTableStatistics(IcebergTableHandle tableHandle) {
        if (tableHandle.getSnapshotId().isEmpty()) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        TupleDomain<IcebergColumnHandle> enforcedPredicate = tableHandle.getEnforcedPredicate();
        if (enforcedPredicate.isNone()) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        Schema icebergTableSchema = this.icebergTable.schema();
        List columns = icebergTableSchema.columns();
        List<IcebergColumnHandle> columnHandles = IcebergUtil.getColumns(icebergTableSchema, this.typeManager);
        Map idToColumnHandle = columnHandles.stream().collect(Collectors.toUnmodifiableMap(IcebergColumnHandle::getId, Function.identity()));
        TableScan tableScan = (TableScan)((TableScan)this.icebergTable.newScan().filter(ExpressionConverter.toIcebergExpression(enforcedPredicate))).useSnapshot(tableHandle.getSnapshotId().get().longValue()).includeColumnStats();
        IcebergStatistics.Builder icebergStatisticsBuilder = new IcebergStatistics.Builder(columns, this.typeManager);
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(fileScanTask -> icebergStatisticsBuilder.acceptDataFile((DataFile)fileScanTask.file(), fileScanTask.spec()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        IcebergStatistics summary = icebergStatisticsBuilder.build();
        if (summary.getFileCount() == 0L) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        Map<Integer, Long> ndvs = this.readNdvs(this.icebergTable);
        ImmutableMap.Builder columnHandleBuilder = ImmutableMap.builder();
        double recordCount = summary.getRecordCount();
        for (IcebergColumnHandle columnHandle : idToColumnHandle.values()) {
            Long columnSize;
            int fieldId = columnHandle.getId();
            ColumnStatistics.Builder columnBuilder = new ColumnStatistics.Builder();
            Long nullCount = summary.getNullCounts().get(fieldId);
            if (nullCount != null) {
                columnBuilder.setNullsFraction(Estimate.of((double)((double)nullCount.longValue() / recordCount)));
            }
            if (summary.getColumnSizes() != null && (columnSize = summary.getColumnSizes().get(fieldId)) != null) {
                columnBuilder.setDataSize(Estimate.of((double)columnSize.longValue()));
            }
            Object min = summary.getMinValues().get(fieldId);
            Object max = summary.getMaxValues().get(fieldId);
            if (min != null && max != null) {
                columnBuilder.setRange(DoubleRange.from((Type)columnHandle.getType(), (Object)min, (Object)max));
            }
            columnBuilder.setDistinctValuesCount(Optional.ofNullable(ndvs.get(fieldId)).map(Estimate::of).orElseGet(Estimate::unknown));
            columnHandleBuilder.put((Object)columnHandle, (Object)columnBuilder.build());
        }
        return new TableStatistics(Estimate.of((double)recordCount), (Map)columnHandleBuilder.buildOrThrow());
    }

    private Map<Integer, Long> readNdvs(Table icebergTable) {
        if (!IcebergSessionProperties.isExtendedStatisticsEnabled(this.session)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder ndvByColumnId = ImmutableMap.builder();
        icebergTable.properties().forEach((key, value) -> {
            Matcher matcher;
            if (key.startsWith(TRINO_STATS_PREFIX) && (matcher = TRINO_STATS_NDV_PATTERN.matcher((CharSequence)key)).matches()) {
                int columnId = Integer.parseInt(matcher.group("columnId"));
                long ndv = Long.parseLong(value);
                ndvByColumnId.put((Object)columnId, (Object)ndv);
            }
        });
        return ndvByColumnId.buildOrThrow();
    }
}

