/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.orc.AbstractOrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import java.io.IOException;
import java.util.Objects;

public class TrinoOrcDataSource
extends AbstractOrcDataSource {
    private final FileFormatDataSourceStats stats;
    private final TrinoInput input;

    public TrinoOrcDataSource(TrinoInputFile file, OrcReaderOptions options, FileFormatDataSourceStats stats) throws IOException {
        super(new OrcDataSourceId(file.location()), file.length(), options);
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.input = file.newInput();
    }

    public void close() throws IOException {
        this.input.close();
    }

    protected Slice readTailInternal(int length) throws IOException {
        long readStart = System.nanoTime();
        Slice tail = this.input.readTail(length);
        this.stats.readDataBytesPerSecond((long)tail.length(), System.nanoTime() - readStart);
        return tail;
    }

    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long readStart = System.nanoTime();
        this.input.readFully(position, buffer, bufferOffset, bufferLength);
        this.stats.readDataBytesPerSecond((long)bufferLength, System.nanoTime() - readStart);
    }
}

