/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HiveViewNotSupportedException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewAdditionalProperties;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;

public abstract class AbstractTrinoCatalog
implements TrinoCatalog {
    protected static final String TRINO_CREATED_BY = "trino_created_by";
    protected static final String TRINO_CREATED_BY_VALUE = "Trino Iceberg connector";
    protected static final String PRESTO_VIEW_COMMENT = "Presto View";
    protected static final String PRESTO_VERSION_NAME = "presto_version";
    protected static final String PRESTO_QUERY_ID_NAME = "presto_query_id";
    protected static final String PRESTO_VIEW_EXPANDED_TEXT_MARKER = "/* Presto View */";
    private final CatalogName catalogName;
    private final TypeManager typeManager;
    protected final IcebergTableOperationsProvider tableOperationsProvider;
    private final String trinoVersion;
    private final boolean useUniqueTableLocation;

    protected AbstractTrinoCatalog(CatalogName catalogName, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, String trinoVersion, boolean useUniqueTableLocation) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.useUniqueTableLocation = useUniqueTableLocation;
    }

    @Override
    public void updateTableComment(ConnectorSession session, SchemaTableName schemaTableName, Optional<String> comment) {
        Table icebergTable = this.loadTable(session, schemaTableName);
        if (comment.isEmpty()) {
            icebergTable.updateProperties().remove("comment").commit();
        } else {
            icebergTable.updateProperties().set("comment", comment.get()).commit();
        }
    }

    @Override
    public void updateColumnComment(ConnectorSession session, SchemaTableName schemaTableName, ColumnIdentity columnIdentity, Optional<String> comment) {
        Table icebergTable = this.loadTable(session, schemaTableName);
        icebergTable.updateSchema().updateColumnDoc(columnIdentity.getName(), (String)comment.orElse(null)).commit();
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (SchemaTableName name : this.listViews(session, namespace)) {
            try {
                this.getView(session, name).ifPresent(view -> views.put((Object)name, view));
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode())) continue;
                throw e;
            }
        }
        return views.buildOrThrow();
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        try {
            return (Optional)Failsafe.with((Policy[])new RetryPolicy[]{new RetryPolicy().withMaxAttempts(10).withBackoff(1L, 5000L, ChronoUnit.MILLIS, 4.0).withMaxDuration(Duration.ofSeconds(30L)).abortOn(failure -> !(failure instanceof MaterializedViewMayBeBeingRemovedException))}).get(() -> this.doGetMaterializedView(session, schemaViewName));
        }
        catch (MaterializedViewMayBeBeingRemovedException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    protected abstract Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession var1, SchemaTableName var2);

    protected Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, String location, Map<String, String> properties, Optional<String> owner) {
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (String)location, properties);
        IcebergTableOperations ops = this.tableOperationsProvider.createTableOperations(this, session, schemaTableName.getSchemaName(), schemaTableName.getTableName(), owner, Optional.of(location));
        return Transactions.createTableTransaction((String)schemaTableName.toString(), (TableOperations)ops, (TableMetadata)metadata);
    }

    protected String createNewTableName(String baseTableName) {
        Object tableName = baseTableName;
        if (this.useUniqueTableLocation) {
            tableName = (String)tableName + "-" + UUID.randomUUID().toString().replace("-", "");
        }
        return tableName;
    }

    protected void deleteTableDirectory(TrinoFileSystem fileSystem, SchemaTableName schemaTableName, String tableLocation) {
        try {
            fileSystem.deleteDirectory(tableLocation);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Failed to delete directory %s of the table %s", tableLocation, schemaTableName), (Throwable)e);
        }
    }

    protected Optional<ConnectorViewDefinition> getView(SchemaTableName viewName, Optional<String> viewOriginalText, String tableType, Map<String, String> tableParameters, Optional<String> tableOwner) {
        if (!AbstractTrinoCatalog.isView(tableType, tableParameters)) {
            return Optional.empty();
        }
        if (!ViewReaderUtil.isPrestoView(tableParameters)) {
            throw new HiveViewNotSupportedException(viewName);
        }
        Preconditions.checkArgument((boolean)viewOriginalText.isPresent(), (Object)"viewOriginalText must be present");
        ConnectorViewDefinition definition = ViewReaderUtil.PrestoViewReader.decodeViewData((String)viewOriginalText.get());
        if (tableOwner.isPresent() && !definition.isRunAsInvoker()) {
            definition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), definition.getComment(), tableOwner, false);
        }
        return Optional.of(definition);
    }

    private static boolean isView(String tableType, Map<String, String> tableParameters) {
        return ViewReaderUtil.isHiveOrPrestoView((String)tableType) && PRESTO_VIEW_COMMENT.equals(tableParameters.get("comment"));
    }

    protected Map<String, String> createViewProperties(ConnectorSession session) {
        return ImmutableMap.builder().put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)TRINO_CREATED_BY_VALUE).put((Object)PRESTO_VERSION_NAME, (Object)this.trinoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).put((Object)"comment", (Object)PRESTO_VIEW_COMMENT).buildOrThrow();
    }

    protected SchemaTableName createMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition) {
        String storageTableName = "st_" + UUID.randomUUID().toString().replace("-", "");
        HashMap<String, String> storageTableProperties = new HashMap<String, String>(definition.getProperties());
        storageTableProperties.putIfAbsent("format", "parquet");
        String storageSchema = IcebergMaterializedViewAdditionalProperties.getStorageSchema(definition.getProperties()).orElse(viewName.getSchemaName());
        SchemaTableName storageTable = new SchemaTableName(storageSchema, storageTableName);
        List columns = (List)definition.getColumns().stream().map(column -> new ColumnMetadata(column.getName(), this.typeManager.getType(column.getType()))).collect(ImmutableList.toImmutableList());
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(storageTable, columns, storageTableProperties, Optional.empty());
        Transaction transaction = IcebergUtil.newCreateTableTransaction(this, tableMetadata, session);
        transaction.newAppend().commit();
        transaction.commitTransaction();
        return storageTable;
    }

    protected ConnectorMaterializedViewDefinition getMaterializedViewDefinition(Table icebergTable, Optional<String> owner, String viewOriginalText, SchemaTableName storageTableName) {
        IcebergMaterializedViewDefinition definition = IcebergMaterializedViewDefinition.decodeMaterializedViewData(viewOriginalText);
        return new ConnectorMaterializedViewDefinition(definition.getOriginalSql(), Optional.of(new CatalogSchemaTableName(this.catalogName.toString(), storageTableName)), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(column -> new ConnectorMaterializedViewDefinition.Column(column.getName(), column.getType())).collect(ImmutableList.toImmutableList()), definition.getComment(), owner, (Map)ImmutableMap.builder().putAll(IcebergUtil.getIcebergTableProperties(icebergTable)).put((Object)"storage_schema", (Object)storageTableName.getSchemaName()).buildOrThrow());
    }

    protected Map<String, String> createMaterializedViewProperties(ConnectorSession session, SchemaTableName storageTableName) {
        return ImmutableMap.builder().put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).put((Object)"storage_schema", (Object)storageTableName.getSchemaName()).put((Object)"storage_table", (Object)storageTableName.getTableName()).put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)TRINO_CREATED_BY_VALUE).put((Object)"comment", (Object)"Presto Materialized View").buildOrThrow();
    }

    protected static class MaterializedViewMayBeBeingRemovedException
    extends RuntimeException {
        public MaterializedViewMayBeBeingRemovedException(Throwable cause) {
            super(Objects.requireNonNull(cause, "cause is null"));
        }
    }
}

