/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.ConcurrentModificationException;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.InvalidInputException;
import com.amazonaws.services.glue.model.ResourceNumberLimitExceededException;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.io.FileIO;

public class GlueIcebergTableOperations
extends AbstractIcebergTableOperations {
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;
    @Nullable
    private String glueVersionId;

    protected GlueIcebergTableOperations(AWSGlueAsync glueClient, GlueMetastoreStats stats, FileIO fileIo, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, session, database, table, owner, location);
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    protected String getRefreshedLocation(boolean invalidateCaches) {
        Table table = this.getTable();
        this.glueVersionId = table.getVersionId();
        Map parameters = (Map)MoreObjects.firstNonNull((Object)table.getParameters(), (Object)ImmutableMap.of());
        if (ViewReaderUtil.isPrestoView((Map)parameters) && ViewReaderUtil.isHiveOrPrestoView((String)table.getTableType())) {
            throw new TableNotFoundException(this.getSchemaTableName());
        }
        if (!HiveUtil.isIcebergTable((Map)parameters)) {
            throw new UnknownTableTypeException(this.getSchemaTableName());
        }
        String metadataLocation = (String)parameters.get("metadata_location");
        if (metadataLocation == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table is missing [%s] property: %s", "metadata_location", this.getSchemaTableName()));
        }
        return metadataLocation;
    }

    @Override
    protected void commitNewTable(TableMetadata metadata) {
        Verify.verify((this.version == -1 ? 1 : 0) != 0, (String)"commitNewTable called on a table which already exists", (Object[])new Object[0]);
        String newMetadataLocation = this.writeNewMetadata(metadata, 0);
        TableInput tableInput = GlueIcebergUtil.getTableInput(this.tableName, this.owner, (Map<String, String>)ImmutableMap.builder().put((Object)"table_type", (Object)"iceberg".toUpperCase(Locale.ENGLISH)).put((Object)"metadata_location", (Object)newMetadataLocation).buildOrThrow());
        CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput);
        this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
        this.shouldRefresh = true;
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version + 1);
        TableInput tableInput = GlueIcebergUtil.getTableInput(this.tableName, this.owner, (Map<String, String>)ImmutableMap.builder().put((Object)"table_type", (Object)"iceberg".toUpperCase(Locale.ENGLISH)).put((Object)"metadata_location", (Object)newMetadataLocation).put((Object)"previous_metadata_location", (Object)this.currentMetadataLocation).buildOrThrow());
        UpdateTableRequest updateTableRequest = new UpdateTableRequest().withDatabaseName(this.database).withTableInput(tableInput).withVersionId(this.glueVersionId);
        try {
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(updateTableRequest));
        }
        catch (ConcurrentModificationException e) {
            throw new CommitFailedException((Throwable)e, "Failed to commit to Glue table: %s.%s", new Object[]{this.database, this.tableName});
        }
        catch (EntityNotFoundException | InvalidInputException | ResourceNumberLimitExceededException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CommitStateUnknownException((Throwable)e);
        }
        this.shouldRefresh = true;
    }

    private Table getTable() {
        try {
            GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(this.database).withName(this.tableName);
            return (Table)this.stats.getGetTable().call(() -> this.glueClient.getTable(getTableRequest).getTable());
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(this.getSchemaTableName(), (Throwable)e);
        }
    }
}

