/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.glue.AWSGlueAsync;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.glue.TrinoGlueCatalog;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class TrinoGlueCatalogFactory
implements TrinoCatalogFactory {
    private final CatalogName catalogName;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final String trinoVersion;
    private final Optional<String> defaultSchemaLocation;
    private final AWSGlueAsync glueClient;
    private final boolean isUniqueTableLocation;
    private final GlueMetastoreStats stats;

    @Inject
    public TrinoGlueCatalogFactory(CatalogName catalogName, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, NodeVersion nodeVersion, GlueHiveMetastoreConfig glueConfig, AWSCredentialsProvider credentialsProvider, IcebergConfig icebergConfig, GlueMetastoreStats stats) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.trinoVersion = nodeVersion.toString();
        this.defaultSchemaLocation = glueConfig.getDefaultWarehouseDir();
        Objects.requireNonNull(credentialsProvider, "credentialsProvider is null");
        this.glueClient = GlueHiveMetastore.createAsyncGlueClient((GlueHiveMetastoreConfig)glueConfig, (AWSCredentialsProvider)credentialsProvider, Optional.empty(), (RequestMetricCollector)stats.newRequestMetricsCollector());
        this.isUniqueTableLocation = icebergConfig.isUniqueTableLocation();
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Managed
    @Flatten
    public GlueMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public TrinoCatalog create(ConnectorIdentity identity) {
        return new TrinoGlueCatalog(this.catalogName, this.fileSystemFactory, this.typeManager, this.tableOperationsProvider, this.trinoVersion, this.glueClient, this.stats, this.defaultSchemaLocation, this.isUniqueTableLocation);
    }
}

