/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.trino.plugin.hive.metastore.AcidTransactionOwner;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.hms.AbstractMetastoreTableOperations;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.io.FileIO;

@NotThreadSafe
public class HiveMetastoreTableOperations
extends AbstractMetastoreTableOperations {
    private static final Logger log = Logger.get(HiveMetastoreTableOperations.class);
    private final ThriftMetastore thriftMetastore;

    public HiveMetastoreTableOperations(FileIO fileIo, CachingHiveMetastore metastore, ThriftMetastore thriftMetastore, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, metastore, session, database, table, owner, location);
        this.thriftMetastore = Objects.requireNonNull(thriftMetastore, "thriftMetastore is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version + 1);
        long lockId = this.thriftMetastore.acquireTableExclusiveLock(new AcidTransactionOwner(this.session.getUser()), this.session.getQueryId(), this.database, this.tableName);
        try {
            Table currentTable = ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)((org.apache.hadoop.hive.metastore.api.Table)this.thriftMetastore.getTable(this.database, this.tableName).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()))));
            Preconditions.checkState((this.currentMetadataLocation != null ? 1 : 0) != 0, (Object)"No current metadata location for existing table");
            String metadataLocation = IcebergUtil.fixBrokenMetadataLocation((String)currentTable.getParameters().get("metadata_location"));
            if (!this.currentMetadataLocation.equals(metadataLocation)) {
                throw new CommitFailedException("Metadata location [%s] is not same as table metadata location [%s] for %s", new Object[]{this.currentMetadataLocation, metadataLocation, this.getSchemaTableName()});
            }
            Table table = Table.builder((Table)currentTable).setDataColumns(HiveMetastoreTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).setParameter("metadata_location", newMetadataLocation).setParameter("previous_metadata_location", this.currentMetadataLocation).build();
            PrincipalPrivileges privileges = table.getOwner().map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
            try {
                this.metastore.replaceTable(this.database, this.tableName, table, privileges);
            }
            catch (RuntimeException e) {
                throw new CommitStateUnknownException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.thriftMetastore.releaseTableLock(lockId);
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Failed to release lock %s when committing to table %s", new Object[]{lockId, this.tableName});
            }
            throw throwable;
        }
        try {
            this.thriftMetastore.releaseTableLock(lockId);
        }
        catch (RuntimeException e) {
            log.error((Throwable)e, "Failed to release lock %s when committing to table %s", new Object[]{lockId, this.tableName});
        }
        this.shouldRefresh = true;
    }
}

