/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.procedure.IcebergProcedureHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IcebergOptimizeHandle
extends IcebergProcedureHandle {
    private final Optional<Long> snapshotId;
    private final String schemaAsJson;
    private final String partitionSpecAsJson;
    private final List<IcebergColumnHandle> tableColumns;
    private final IcebergFileFormat fileFormat;
    private final Map<String, String> tableStorageProperties;
    private final DataSize maxScannedFileSize;
    private final boolean retriesEnabled;

    @JsonCreator
    public IcebergOptimizeHandle(Optional<Long> snapshotId, String schemaAsJson, String partitionSpecAsJson, List<IcebergColumnHandle> tableColumns, IcebergFileFormat fileFormat, Map<String, String> tableStorageProperties, DataSize maxScannedFileSize, boolean retriesEnabled) {
        this.snapshotId = snapshotId;
        this.schemaAsJson = Objects.requireNonNull(schemaAsJson, "schemaAsJson is null");
        this.partitionSpecAsJson = Objects.requireNonNull(partitionSpecAsJson, "partitionSpecAsJson is null");
        this.tableColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableColumns, "tableColumns is null"));
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.tableStorageProperties = ImmutableMap.copyOf(Objects.requireNonNull(tableStorageProperties, "tableStorageProperties is null"));
        this.maxScannedFileSize = Objects.requireNonNull(maxScannedFileSize, "maxScannedFileSize is null");
        this.retriesEnabled = retriesEnabled;
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    @JsonProperty
    public String getSchemaAsJson() {
        return this.schemaAsJson;
    }

    @JsonProperty
    public String getPartitionSpecAsJson() {
        return this.partitionSpecAsJson;
    }

    @JsonProperty
    public List<IcebergColumnHandle> getTableColumns() {
        return this.tableColumns;
    }

    @JsonProperty
    public IcebergFileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty
    public Map<String, String> getTableStorageProperties() {
        return this.tableStorageProperties;
    }

    @JsonProperty
    public DataSize getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    @JsonProperty
    public boolean isRetriesEnabled() {
        return this.retriesEnabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("snapshotId", this.snapshotId).add("schemaAsJson", (Object)this.schemaAsJson).add("partitionSpecAsJson", (Object)this.partitionSpecAsJson).add("tableColumns", this.tableColumns).add("fileFormat", (Object)this.fileFormat).add("tableStorageProperties", this.tableStorageProperties).add("maxScannedFileSize", (Object)this.maxScannedFileSize).add("retriesEnabled", this.retriesEnabled).toString();
    }
}

