/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal.apache.http.impl.cookie;

import com.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import com.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import com.clickhouse.jdbc.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.clickhouse.jdbc.internal.apache.http.cookie.Cookie;
import com.clickhouse.jdbc.internal.apache.http.cookie.CookieOrigin;
import com.clickhouse.jdbc.internal.apache.http.cookie.MalformedCookieException;
import com.clickhouse.jdbc.internal.apache.http.cookie.SetCookie;
import com.clickhouse.jdbc.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.clickhouse.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

