/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.writer.ParquetSchemaConverter;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeWriter;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.parquet.ParquetFileWriter;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.MergePage;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.joda.time.DateTimeZone;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class DeltaLakeMergeSink
implements ConnectorMergeSink {
    private static final JsonCodec<List<String>> PARTITIONS_CODEC = JsonCodec.listJsonCodec(String.class);
    private final TrinoFileSystemFactory fileSystemFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final ConnectorSession session;
    private final DateTimeZone parquetDateTimeZone;
    private final String trinoVersion;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec;
    private final DeltaLakeWriterStats writerStats;
    private final String rootTableLocation;
    private final ConnectorPageSink insertPageSink;
    private final List<DeltaLakeColumnHandle> dataColumns;
    private final int tableColumnCount;
    private final Map<Slice, FileDeletion> fileDeletions = new HashMap<Slice, FileDeletion>();

    public DeltaLakeMergeSink(TrinoFileSystemFactory fileSystemFactory, HdfsEnvironment hdfsEnvironment, ConnectorSession session, DateTimeZone parquetDateTimeZone, String trinoVersion, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec, DeltaLakeWriterStats writerStats, String rootTableLocation, ConnectorPageSink insertPageSink, List<DeltaLakeColumnHandle> tableColumns) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.parquetDateTimeZone = Objects.requireNonNull(parquetDateTimeZone, "parquetDateTimeZone is null");
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        this.mergeResultJsonCodec = Objects.requireNonNull(mergeResultJsonCodec, "mergeResultJsonCodec is null");
        this.writerStats = Objects.requireNonNull(writerStats, "writerStats is null");
        this.rootTableLocation = Objects.requireNonNull(rootTableLocation, "rootTableLocation is null");
        this.insertPageSink = Objects.requireNonNull(insertPageSink, "insertPageSink is null");
        Objects.requireNonNull(tableColumns, "tableColumns is null");
        this.tableColumnCount = tableColumns.size();
        this.dataColumns = (List)tableColumns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.REGULAR).collect(ImmutableList.toImmutableList());
    }

    public void storeMergedRows(Page page) {
        MergePage mergePage = MergePage.createDeleteAndInsertPages((Page)page, (int)this.tableColumnCount);
        mergePage.getInsertionsPage().ifPresent(arg_0 -> ((ConnectorPageSink)this.insertPageSink).appendPage(arg_0));
        mergePage.getDeletionsPage().ifPresent(deletions -> {
            ColumnarRow rowIdRow = ColumnarRow.toColumnarRow((Block)deletions.getBlock(deletions.getChannelCount() - 1));
            for (int position = 0; position < rowIdRow.getPositionCount(); ++position) {
                Slice filePath = VarcharType.VARCHAR.getSlice(rowIdRow.getField(0), position);
                long rowPosition = BigintType.BIGINT.getLong(rowIdRow.getField(1), position);
                Slice partitions = VarcharType.VARCHAR.getSlice(rowIdRow.getField(2), position);
                List partitionValues = (List)PARTITIONS_CODEC.fromJson(partitions.toStringUtf8());
                FileDeletion deletion = this.fileDeletions.computeIfAbsent(filePath, x -> new FileDeletion(partitionValues));
                deletion.rowsToDelete().addLong(rowPosition);
            }
        });
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ArrayList fragments = new ArrayList();
        ((Collection)this.insertPageSink.finish().join()).stream().map(Slice::getBytes).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).map(info -> new DeltaLakeMergeResult(Optional.empty(), Optional.of(info))).map(arg_0 -> this.mergeResultJsonCodec.toJsonBytes(arg_0)).map(Slices::wrappedBuffer).forEach(fragments::add);
        this.fileDeletions.forEach((path, deletion) -> fragments.addAll(this.rewriteFile(new Path(path.toStringUtf8()), (FileDeletion)deletion)));
        return CompletableFuture.completedFuture(fragments);
    }

    private List<Slice> rewriteFile(Path sourcePath, FileDeletion deletion) {
        try {
            Path rootTablePath = new Path(this.rootTableLocation);
            String sourceRelativePath = rootTablePath.toUri().relativize(sourcePath.toUri()).toString();
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsContext(this.session.getIdentity()), rootTablePath);
            Path targetPath = new Path(sourcePath.getParent(), this.session.getQueryId() + "_" + UUID.randomUUID());
            String targetRelativePath = rootTablePath.toUri().relativize(targetPath.toUri()).toString();
            FileWriter fileWriter = this.createParquetFileWriter(fileSystem, targetPath, this.dataColumns);
            DeltaLakeWriter writer = new DeltaLakeWriter(fileSystem, fileWriter, rootTablePath, targetRelativePath, deletion.partitionValues(), this.writerStats, this.dataColumns);
            Optional<DataFileInfo> newFileInfo = this.rewriteParquetFile(sourcePath, (ImmutableLongBitmapDataProvider)deletion.rowsToDelete(), writer);
            DeltaLakeMergeResult result = new DeltaLakeMergeResult(Optional.of(sourceRelativePath), newFileInfo);
            return ImmutableList.of((Object)Slices.utf8Slice((String)this.mergeResultJsonCodec.toJson((Object)result)));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to rewrite Parquet file", (Throwable)e);
        }
    }

    private FileWriter createParquetFileWriter(FileSystem fileSystem, Path path, List<DeltaLakeColumnHandle> dataColumns) {
        ParquetWriterOptions parquetWriterOptions = ParquetWriterOptions.builder().setMaxBlockSize(DeltaLakeSessionProperties.getParquetWriterBlockSize(this.session)).setMaxPageSize(DeltaLakeSessionProperties.getParquetWriterPageSize(this.session)).build();
        CompressionCodecName compressionCodecName = DeltaLakeSessionProperties.getCompressionCodec(this.session).getParquetCompressionCodec();
        try {
            Callable<Void> rollbackAction = () -> {
                fileSystem.delete(path, false);
                return null;
            };
            List parquetTypes = (List)dataColumns.stream().map(column -> {
                Type type = column.getType();
                if (type instanceof TimestampWithTimeZoneType) {
                    TimestampWithTimeZoneType timestamp = (TimestampWithTimeZoneType)type;
                    Verify.verify((timestamp.getPrecision() == 3 ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
                    return TimestampType.TIMESTAMP_MILLIS;
                }
                return type;
            }).collect(ImmutableList.toImmutableList());
            List dataColumnNames = (List)dataColumns.stream().map(DeltaLakeColumnHandle::getName).collect(ImmutableList.toImmutableList());
            ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter(parquetTypes, dataColumnNames, false, false);
            return new ParquetFileWriter((OutputStream)fileSystem.create(path), rollbackAction, parquetTypes, dataColumnNames, schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), parquetWriterOptions, IntStream.range(0, dataColumns.size()).toArray(), compressionCodecName, this.trinoVersion, Optional.empty(), Optional.empty());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Error creating Parquet file", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<DataFileInfo> rewriteParquetFile(Path path, ImmutableLongBitmapDataProvider rowsToDelete, DeltaLakeWriter fileWriter) throws IOException {
        try (ConnectorPageSource connectorPageSource = this.createParquetPageSource(path).get();){
            long filePosition = 0L;
            while (!connectorPageSource.isFinished()) {
                Page page = connectorPageSource.getNextPage();
                if (page == null) continue;
                int positionCount = page.getPositionCount();
                int[] retained = new int[positionCount];
                int retainedCount = 0;
                for (int position = 0; position < positionCount; ++filePosition, ++position) {
                    if (rowsToDelete.contains(filePosition)) continue;
                    retained[retainedCount] = position;
                    ++retainedCount;
                }
                if (retainedCount != positionCount) {
                    page = page.getPositions(retained, 0, retainedCount);
                }
                if (page.getPositionCount() <= 0) continue;
                fileWriter.appendRows(page);
            }
            if (fileWriter.getRowCount() == 0L) {
                fileWriter.rollback();
                Optional<DataFileInfo> optional = Optional.empty();
                return optional;
            }
            fileWriter.commit();
            return Optional.of(fileWriter.getDataFileInfo());
        }
        catch (Throwable t) {
            try {
                fileWriter.rollback();
                throw t;
            }
            catch (RuntimeException e) {
                if (t.equals(e)) throw t;
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    private ReaderPageSource createParquetPageSource(Path path) throws IOException {
        TrinoInputFile inputFile = this.fileSystemFactory.create(this.session).newInputFile(path.toString());
        return ParquetPageSourceFactory.createPageSource((TrinoInputFile)inputFile, (long)0L, (long)inputFile.length(), (List)((List)this.dataColumns.stream().map(DeltaLakeColumnHandle::toHiveColumnHandle).collect(ImmutableList.toImmutableList())), (TupleDomain)TupleDomain.all(), (boolean)true, (DateTimeZone)this.parquetDateTimeZone, (FileFormatDataSourceStats)new FileFormatDataSourceStats(), (ParquetReaderOptions)new ParquetReaderOptions(), Optional.empty());
    }

    private static class FileDeletion {
        private final List<String> partitionValues;
        private final LongBitmapDataProvider rowsToDelete = new Roaring64Bitmap();

        private FileDeletion(List<String> partitionValues) {
            this.partitionValues = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(partitionValues, "partitionValues is null")));
        }

        public List<String> partitionValues() {
            return this.partitionValues;
        }

        public LongBitmapDataProvider rowsToDelete() {
            return this.rowsToDelete;
        }
    }
}

