/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public final class DeltaLakeSessionProperties
implements SessionPropertiesProvider {
    private static final String MAX_SPLIT_SIZE = "max_split_size";
    private static final String MAX_INITIAL_SPLIT_SIZE = "max_initial_split_size";
    public static final String VACUUM_MIN_RETENTION = "vacuum_min_retention";
    private static final String HIVE_CATALOG_NAME = "hive_catalog_name";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_USE_COLUMN_INDEX = "parquet_use_column_index";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private static final String TARGET_MAX_FILE_SIZE = "target_max_file_size";
    private static final String PARQUET_OPTIMIZED_WRITER_ENABLED = "parquet_optimized_writer_enabled";
    private static final String COMPRESSION_CODEC = "compression_codec";
    @Deprecated
    private static final String TIMESTAMP_PRECISION = "timestamp_precision";
    private static final String DYNAMIC_FILTERING_WAIT_TIMEOUT = "dynamic_filtering_wait_timeout";
    private static final String TABLE_STATISTICS_ENABLED = "statistics_enabled";
    public static final String EXTENDED_STATISTICS_ENABLED = "extended_statistics_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public DeltaLakeSessionProperties(DeltaLakeConfig deltaLakeConfig, ParquetReaderConfig parquetReaderConfig, ParquetWriterConfig parquetWriterConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadataUtil.dataSizeProperty((String)MAX_SPLIT_SIZE, (String)"Max split size", (DataSize)deltaLakeConfig.getMaxSplitSize(), (boolean)true), (Object)PropertyMetadataUtil.dataSizeProperty((String)MAX_INITIAL_SPLIT_SIZE, (String)"Max initial split size", (DataSize)deltaLakeConfig.getMaxInitialSplitSize(), (boolean)true), (Object)PropertyMetadataUtil.durationProperty((String)VACUUM_MIN_RETENTION, (String)"Minimal retention period for vacuum procedure", (Duration)deltaLakeConfig.getVacuumMinRetention(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)HIVE_CATALOG_NAME, (String)"Catalog to redirect to when a Hive table is referenced", (String)deltaLakeConfig.getHiveCatalogName().orElse(null), (boolean)true), (Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)parquetReaderConfig.getMaxReadBlockSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_USE_COLUMN_INDEX, (String)"Use Parquet column index", (Boolean)parquetReaderConfig.isUseColumnIndex(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_BLOCK_SIZE, (String)"Parquet: Writer block size", (DataSize)parquetWriterConfig.getBlockSize(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_PAGE_SIZE, (String)"Parquet: Writer page size", (DataSize)parquetWriterConfig.getPageSize(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)TARGET_MAX_FILE_SIZE, (String)"Target maximum size of written files; the actual size may be larger", (DataSize)deltaLakeConfig.getTargetMaxFileSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_OPTIMIZED_WRITER_ENABLED, (String)"Enable optimized writer", (Boolean)parquetWriterConfig.isParquetOptimizedWriterEnabled(), (boolean)false), (Object)PropertyMetadata.enumProperty((String)TIMESTAMP_PRECISION, (String)"Internal Delta Lake connector property", HiveTimestampPrecision.class, (Enum)HiveTimestampPrecision.MILLISECONDS, value -> {
            throw new IllegalStateException("The property cannot be set");
        }, (boolean)true), (Object)PropertyMetadataUtil.durationProperty((String)DYNAMIC_FILTERING_WAIT_TIMEOUT, (String)"Duration to wait for completion of dynamic filters during split generation", (Duration)deltaLakeConfig.getDynamicFilteringWaitTimeout(), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.booleanProperty((String)TABLE_STATISTICS_ENABLED, (String)"Expose table statistics", (Boolean)deltaLakeConfig.isTableStatisticsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)EXTENDED_STATISTICS_ENABLED, (String)"Use extended statistics collected by ANALYZE", (Boolean)deltaLakeConfig.isExtendedStatisticsEnabled(), (boolean)false), PropertyMetadata.enumProperty((String)COMPRESSION_CODEC, (String)"Compression codec to use when writing new data files", HiveCompressionCodec.class, (Enum)deltaLakeConfig.getCompressionCodec(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static DataSize getMaxSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_SPLIT_SIZE, DataSize.class);
    }

    public static DataSize getMaxInitialSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_INITIAL_SPLIT_SIZE, DataSize.class);
    }

    public static Duration getVacuumMinRetention(ConnectorSession session) {
        return (Duration)session.getProperty(VACUUM_MIN_RETENTION, Duration.class);
    }

    public static Optional<String> getHiveCatalogName(ConnectorSession session) {
        return Optional.ofNullable((String)session.getProperty(HIVE_CATALOG_NAME, String.class));
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean isParquetUseColumnIndex(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_COLUMN_INDEX, Boolean.class);
    }

    public static boolean isParquetOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static DataSize getParquetWriterBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_BLOCK_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterPageSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static long getTargetMaxFileSize(ConnectorSession session) {
        return ((DataSize)session.getProperty(TARGET_MAX_FILE_SIZE, DataSize.class)).toBytes();
    }

    public static Duration getDynamicFilteringWaitTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(DYNAMIC_FILTERING_WAIT_TIMEOUT, Duration.class);
    }

    public static boolean isTableStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(TABLE_STATISTICS_ENABLED, Boolean.class);
    }

    public static boolean isExtendedStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(EXTENDED_STATISTICS_ENABLED, Boolean.class);
    }

    public static HiveCompressionCodec getCompressionCodec(ConnectorSession session) {
        return (HiveCompressionCodec)session.getProperty(COMPRESSION_CODEC, HiveCompressionCodec.class);
    }
}

