/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.deltalake.statistics.DeltaLakeColumnStatistics;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ExtendedStatistics {
    public static final long CURRENT_MODEL_VERSION = 4L;
    private final long modelVersion;
    private final Instant alreadyAnalyzedModifiedTimeMax;
    private final Map<String, DeltaLakeColumnStatistics> columnStatistics;
    private final Optional<Set<String>> analyzedColumns;

    public ExtendedStatistics(Instant alreadyAnalyzedModifiedTimeMax, Map<String, DeltaLakeColumnStatistics> columnStatistics, Optional<Set<String>> analyzedColumns) {
        this(4L, alreadyAnalyzedModifiedTimeMax, columnStatistics, analyzedColumns);
    }

    @JsonCreator
    public ExtendedStatistics(@JsonProperty(value="modelVersion") long modelVersion, @JsonProperty(value="alreadyAnalyzedModifiedTimeMax") Instant alreadyAnalyzedModifiedTimeMax, @JsonProperty(value="columnStatistics") Map<String, DeltaLakeColumnStatistics> columnStatistics, @JsonProperty(value="analyzedColumns") Optional<Set<String>> analyzedColumns) {
        this.modelVersion = modelVersion;
        this.alreadyAnalyzedModifiedTimeMax = alreadyAnalyzedModifiedTimeMax;
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
        Objects.requireNonNull(analyzedColumns, "analyzedColumns is null");
        this.analyzedColumns = analyzedColumns.map(ImmutableSet::copyOf);
    }

    @JsonProperty
    public long getModelVersion() {
        return this.modelVersion;
    }

    @JsonProperty
    public Instant getAlreadyAnalyzedModifiedTimeMax() {
        return this.alreadyAnalyzedModifiedTimeMax;
    }

    @JsonProperty
    public Map<String, DeltaLakeColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    @JsonProperty
    public Optional<Set<String>> getAnalyzedColumns() {
        return this.analyzedColumns;
    }
}

