/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatisticsAccess;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class MetaDirStatisticsAccess
implements ExtendedStatisticsAccess {
    private static final String STATISTICS_META_DIR = "_delta_log/_trino_meta";
    private static final String STATISTICS_FILE = "extended_stats.json";
    private static final String STARBURST_META_DIR = "_delta_log/_starburst_meta";
    private static final String STARBURST_STATISTICS_FILE = "extendeded_stats.json";
    private final HdfsEnvironment hdfsEnvironment;
    private final JsonCodec<ExtendedStatistics> statisticsCodec;

    @Inject
    public MetaDirStatisticsAccess(HdfsEnvironment hdfsEnvironment, JsonCodec<ExtendedStatistics> statisticsCodec) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.statisticsCodec = Objects.requireNonNull(statisticsCodec, "statisticsCodec is null");
    }

    @Override
    public Optional<ExtendedStatistics> readExtendedStatistics(ConnectorSession session, String tableLocation) {
        return this.readExtendedStatistics(session, tableLocation, STATISTICS_META_DIR, STATISTICS_FILE).or(() -> this.readExtendedStatistics(session, tableLocation, STARBURST_META_DIR, STARBURST_STATISTICS_FILE));
    }

    private Optional<ExtendedStatistics> readExtendedStatistics(ConnectorSession session, String tableLocation, String statisticsDirectory, String statisticsFile) {
        Optional<ExtendedStatistics> optional;
        block9: {
            Path statisticsPath = new Path(new Path(tableLocation, statisticsDirectory), statisticsFile);
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsContext(session), statisticsPath);
            if (!fileSystem.exists(statisticsPath)) {
                return Optional.empty();
            }
            FSDataInputStream inputStream = fileSystem.open(statisticsPath);
            try {
                optional = Optional.of((ExtendedStatistics)this.statisticsCodec.fromJson(inputStream.readAllBytes()));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("failed to read statistics with table location %s", tableLocation), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    @Override
    public void updateExtendedStatistics(ConnectorSession session, String tableLocation, ExtendedStatistics statistics) {
        Path metaPath = new Path(tableLocation, STATISTICS_META_DIR);
        this.ensureDirectoryExists(session, metaPath);
        try {
            Path statisticsPath = new Path(metaPath, STATISTICS_FILE);
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsContext(session), metaPath);
            try (FSDataOutputStream outputStream = fileSystem.create(statisticsPath, true);){
                outputStream.write(this.statisticsCodec.toJsonBytes((Object)statistics));
            }
            fileSystem.delete(new Path(new Path(tableLocation, STARBURST_META_DIR), STARBURST_STATISTICS_FILE), false);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("failed to store statistics with table location %s", tableLocation), (Throwable)e);
        }
    }

    @Override
    public void deleteExtendedStatistics(ConnectorSession session, String tableLocation) {
        Path statisticsPath = new Path(new Path(tableLocation, STATISTICS_META_DIR), STATISTICS_FILE);
        try {
            FileSystem hdfs = this.hdfsEnvironment.getFileSystem(new HdfsContext(session), statisticsPath);
            if (!hdfs.delete(statisticsPath, false) && hdfs.exists(statisticsPath)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Failed to delete statistics file %s", statisticsPath));
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error deleting statistics file %s", statisticsPath), (Throwable)e);
        }
    }

    private void ensureDirectoryExists(ConnectorSession session, Path directoryPath) {
        HdfsContext hdfsContext = new HdfsContext(session);
        if (!HiveWriteUtils.pathExists((HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)directoryPath)) {
            HiveWriteUtils.createDirectory((HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)directoryPath);
        }
    }
}

