/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class CanonicalColumnName {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(CanonicalColumnName.class).instanceSize());
    private int hash;
    private final String originalName;

    public CanonicalColumnName(String originalName) {
        this.originalName = Objects.requireNonNull(originalName, "originalName is null");
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalColumnName that = (CanonicalColumnName)o;
        return this.hashCode() == that.hashCode() && Objects.equals(TransactionLogAccess.canonicalizeColumnName(this.originalName), TransactionLogAccess.canonicalizeColumnName(that.originalName));
    }

    public int hashCode() {
        if (this.hash == 0) {
            int newHash = TransactionLogAccess.canonicalizeColumnName(this.originalName).hashCode();
            if (newHash == 0) {
                newHash = 1;
            }
            this.hash = newHash;
        }
        return this.hash;
    }

    public long getRetainedSize() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.originalName);
    }
}

