/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.TypeManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;

public class TableSnapshot {
    private final Optional<LastCheckpoint> lastCheckpoint;
    private final SchemaTableName table;
    private final TransactionLogTail logTail;
    private final Path tableLocation;
    private final ParquetReaderOptions parquetReaderOptions;
    private final boolean checkpointRowStatisticsWritingEnabled;
    private Optional<MetadataEntry> cachedMetadata = Optional.empty();

    private TableSnapshot(SchemaTableName table, Optional<LastCheckpoint> lastCheckpoint, TransactionLogTail logTail, Path tableLocation, ParquetReaderOptions parquetReaderOptions, boolean checkpointRowStatisticsWritingEnabled) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.lastCheckpoint = Objects.requireNonNull(lastCheckpoint, "lastCheckpoint is null");
        this.logTail = Objects.requireNonNull(logTail, "logTail is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
        this.checkpointRowStatisticsWritingEnabled = checkpointRowStatisticsWritingEnabled;
    }

    public static TableSnapshot load(SchemaTableName table, TrinoFileSystem fileSystem, Path tableLocation, ParquetReaderOptions parquetReaderOptions, boolean checkpointRowStatisticsWritingEnabled) throws IOException {
        Optional<LastCheckpoint> lastCheckpoint = TransactionLogParser.readLastCheckpoint(fileSystem, tableLocation);
        Optional<Long> lastCheckpointVersion = lastCheckpoint.map(LastCheckpoint::getVersion);
        TransactionLogTail transactionLogTail = TransactionLogTail.loadNewTail(fileSystem, tableLocation, lastCheckpointVersion);
        return new TableSnapshot(table, lastCheckpoint, transactionLogTail, tableLocation, parquetReaderOptions, checkpointRowStatisticsWritingEnabled);
    }

    public Optional<TableSnapshot> getUpdatedSnapshot(TrinoFileSystem fileSystem) throws IOException {
        Optional<LastCheckpoint> lastCheckpoint = TransactionLogParser.readLastCheckpoint(fileSystem, this.tableLocation);
        long lastCheckpointVersion = lastCheckpoint.map(LastCheckpoint::getVersion).orElse(0L);
        long cachedLastCheckpointVersion = this.getLastCheckpointVersion().orElse(0L);
        Optional<TransactionLogTail> updatedLogTail = cachedLastCheckpointVersion == lastCheckpointVersion ? this.logTail.getUpdatedTail(fileSystem, this.tableLocation) : Optional.of(TransactionLogTail.loadNewTail(fileSystem, this.tableLocation, Optional.of(lastCheckpointVersion)));
        return updatedLogTail.map(transactionLogTail -> new TableSnapshot(this.table, lastCheckpoint, (TransactionLogTail)transactionLogTail, this.tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled));
    }

    public long getVersion() {
        return this.logTail.getVersion();
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public Optional<MetadataEntry> getCachedMetadata() {
        return this.cachedMetadata;
    }

    public Path getTableLocation() {
        return this.tableLocation;
    }

    public void setCachedMetadata(Optional<MetadataEntry> cachedMetadata) {
        this.cachedMetadata = cachedMetadata;
    }

    public List<DeltaLakeTransactionLogEntry> getJsonTransactionLogEntries() {
        return this.logTail.getFileEntries();
    }

    public Stream<DeltaLakeTransactionLogEntry> getCheckpointTransactionLogEntries(ConnectorSession session, Set<CheckpointEntryIterator.EntryType> entryTypes, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats) throws IOException {
        if (this.lastCheckpoint.isEmpty()) {
            return Stream.empty();
        }
        LastCheckpoint checkpoint = this.lastCheckpoint.get();
        Optional<MetadataEntry> metadataEntry = entryTypes.contains((Object)CheckpointEntryIterator.EntryType.ADD) ? Optional.of(this.getCheckpointMetadataEntry(session, checkpointSchemaManager, typeManager, fileSystem, stats, checkpoint)) : Optional.empty();
        Stream<DeltaLakeTransactionLogEntry> resultStream = Stream.empty();
        for (Path checkpointPath : this.getCheckpointPartPaths(checkpoint)) {
            TrinoInputFile checkpointFile = fileSystem.newInputFile(checkpointPath.toString());
            resultStream = Stream.concat(resultStream, this.getCheckpointTransactionLogEntries(session, entryTypes, metadataEntry, checkpointSchemaManager, typeManager, stats, checkpoint, checkpointFile));
        }
        return resultStream;
    }

    public Optional<Long> getLastCheckpointVersion() {
        return this.lastCheckpoint.map(LastCheckpoint::getVersion);
    }

    private Stream<DeltaLakeTransactionLogEntry> getCheckpointTransactionLogEntries(ConnectorSession session, Set<CheckpointEntryIterator.EntryType> entryTypes, Optional<MetadataEntry> metadataEntry, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, FileFormatDataSourceStats stats, LastCheckpoint checkpoint, TrinoInputFile checkpointFile) throws IOException {
        long fileSize;
        try {
            fileSize = checkpointFile.length();
        }
        catch (FileNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("%s mentions a non-existent checkpoint file for table: %s", checkpoint, this.table));
        }
        return Streams.stream((Iterator)new CheckpointEntryIterator(checkpointFile, session, fileSize, checkpointSchemaManager, typeManager, entryTypes, metadataEntry, stats, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled));
    }

    private MetadataEntry getCheckpointMetadataEntry(ConnectorSession session, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats, LastCheckpoint checkpoint) throws IOException {
        for (Path checkpointPath : this.getCheckpointPartPaths(checkpoint)) {
            TrinoInputFile checkpointFile = fileSystem.newInputFile(checkpointPath.toString());
            Stream<DeltaLakeTransactionLogEntry> metadataEntries = this.getCheckpointTransactionLogEntries(session, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.METADATA)), Optional.empty(), checkpointSchemaManager, typeManager, stats, checkpoint, checkpointFile);
            Optional<DeltaLakeTransactionLogEntry> metadataEntry = metadataEntries.findFirst();
            if (!metadataEntry.isPresent()) continue;
            return metadataEntry.get().getMetaData();
        }
        throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_DATA, "Checkpoint found without metadata entry: " + checkpoint);
    }

    private List<Path> getCheckpointPartPaths(LastCheckpoint checkpoint) {
        Path transactionLogDir = TransactionLogUtil.getTransactionLogDir(this.tableLocation);
        ImmutableList.Builder paths = ImmutableList.builder();
        if (checkpoint.getParts().isEmpty()) {
            paths.add((Object)new Path(transactionLogDir, String.format("%020d.checkpoint.parquet", checkpoint.getVersion())));
        } else {
            int partsCount = checkpoint.getParts().get();
            for (int i = 1; i <= partsCount; ++i) {
                paths.add((Object)new Path(transactionLogDir, String.format("%020d.checkpoint.%010d.%010d.parquet", checkpoint.getVersion(), i, partsCount)));
            }
        }
        return paths.build();
    }
}

