/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

public class AbfsPermission
extends FsPermission {
    private static final int STICKY_BIT_OCTAL_VALUE = 512;
    private final boolean aclBit;

    public AbfsPermission(Short aShort, boolean aclBitStatus) {
        super(aShort);
        this.aclBit = aclBitStatus;
    }

    public AbfsPermission(FsAction u, FsAction g, FsAction o) {
        super(u, g, o, false);
        this.aclBit = false;
    }

    @Override
    public boolean getAclBit() {
        return this.aclBit;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FsPermission) {
            FsPermission that = (FsPermission)obj;
            return this.getUserAction() == that.getUserAction() && this.getGroupAction() == that.getGroupAction() && this.getOtherAction() == that.getOtherAction() && this.getStickyBit() == that.getStickyBit();
        }
        return false;
    }

    public static AbfsPermission valueOf(String abfsSymbolicPermission) {
        if (abfsSymbolicPermission == null) {
            return null;
        }
        boolean isExtendedAcl = abfsSymbolicPermission.charAt(abfsSymbolicPermission.length() - 1) == '+';
        String abfsRawSymbolicPermission = isExtendedAcl ? abfsSymbolicPermission.substring(0, abfsSymbolicPermission.length() - 1) : abfsSymbolicPermission;
        int n = 0;
        for (int i = 0; i < abfsRawSymbolicPermission.length(); ++i) {
            n <<= 1;
            char c = abfsRawSymbolicPermission.charAt(i);
            n += c == '-' || c == 'T' || c == 'S' ? 0 : 1;
        }
        if (abfsRawSymbolicPermission.charAt(abfsRawSymbolicPermission.length() - 1) == 't' || abfsRawSymbolicPermission.charAt(abfsRawSymbolicPermission.length() - 1) == 'T') {
            n += 512;
        }
        return new AbfsPermission((short)n, isExtendedAcl);
    }

    public static boolean isExtendedAcl(String abfsSymbolicPermission) {
        if (abfsSymbolicPermission == null) {
            return false;
        }
        return abfsSymbolicPermission.charAt(abfsSymbolicPermission.length() - 1) == '+';
    }

    @Override
    public int hashCode() {
        return this.toShort();
    }
}

