/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class FixedSplitSource
implements ConnectorSplitSource {
    private final List<ConnectorSplit> splits;
    private final Optional<List<Object>> tableExecuteSplitsInfo;
    private int offset;

    public FixedSplitSource(Iterable<? extends ConnectorSplit> splits) {
        this(splits, Optional.empty());
    }

    public FixedSplitSource(Iterable<? extends ConnectorSplit> splits, List<Object> tableExecuteSplitsInfo) {
        this(splits, Optional.of(tableExecuteSplitsInfo));
    }

    private FixedSplitSource(Iterable<? extends ConnectorSplit> splits, Optional<List<Object>> tableExecuteSplitsInfo) {
        Objects.requireNonNull(splits, "splits is null");
        this.splits = StreamSupport.stream(splits.spliterator(), false).collect(Collectors.toUnmodifiableList());
        this.tableExecuteSplitsInfo = tableExecuteSplitsInfo.map(List::copyOf);
    }

    @Override
    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        int remainingSplits = this.splits.size() - this.offset;
        int size = Math.min(remainingSplits, maxSize);
        List<ConnectorSplit> results = this.splits.subList(this.offset, this.offset + size);
        this.offset += size;
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(results, this.isFinished()));
    }

    @Override
    public boolean isFinished() {
        return this.offset >= this.splits.size();
    }

    @Override
    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        return this.tableExecuteSplitsInfo;
    }

    @Override
    public void close() {
    }
}

