/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.eventlistener.SplitFailureInfo;
import io.trino.spi.eventlistener.SplitStatistics;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class SplitCompletedEvent {
    private final String queryId;
    private final String stageId;
    private final String taskId;
    private final Optional<String> catalogName;
    private final Instant createTime;
    private final Optional<Instant> startTime;
    private final Optional<Instant> endTime;
    private final SplitStatistics statistics;
    private final Optional<SplitFailureInfo> failureInfo;
    private final String payload;

    @JsonCreator
    public SplitCompletedEvent(String queryId, String stageId, String taskId, Optional<String> catalogName, Instant createTime, Optional<Instant> startTime, Optional<Instant> endTime, SplitStatistics statistics, Optional<SplitFailureInfo> failureInfo, String payload) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.startTime = Objects.requireNonNull(startTime, "startTime is null");
        this.endTime = Objects.requireNonNull(endTime, "endTime is null");
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
        this.payload = Objects.requireNonNull(payload, "payload is null");
    }

    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public String getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public Instant getCreateTime() {
        return this.createTime;
    }

    @JsonProperty
    public Optional<Instant> getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Optional<Instant> getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public SplitStatistics getStatistics() {
        return this.statistics;
    }

    @JsonProperty
    public Optional<SplitFailureInfo> getFailureInfo() {
        return this.failureInfo;
    }

    @JsonProperty
    public String getPayload() {
        return this.payload;
    }

    @JsonProperty
    public Optional<String> getCatalogName() {
        return this.catalogName;
    }

    public String toString() {
        return new StringJoiner(", ", SplitCompletedEvent.class.getSimpleName() + "[", "]").add("queryId='" + this.queryId + "'").add("stageId='" + this.stageId + "'").add("taskId='" + this.taskId + "'").toString();
    }
}

