/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.Slices;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public final class VarcharType
extends AbstractVariableWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(VarcharType.class, MethodHandles.lookup(), Slice.class);
    public static final int UNBOUNDED_LENGTH = Integer.MAX_VALUE;
    public static final int MAX_LENGTH = 0x7FFFFFFE;
    public static final VarcharType VARCHAR = new VarcharType(Integer.MAX_VALUE);
    private final int length;

    public static VarcharType createUnboundedVarcharType() {
        return VARCHAR;
    }

    public static VarcharType createVarcharType(int length) {
        if (length > 0x7FFFFFFE || length < 0) {
            throw new IllegalArgumentException("Invalid VARCHAR length " + length);
        }
        return new VarcharType(length);
    }

    private VarcharType(int length) {
        super(new TypeSignature("varchar", Collections.singletonList(TypeSignatureParameter.numericParameter(length))), Slice.class);
        if (length < 0) {
            throw new IllegalArgumentException("Invalid VARCHAR length " + length);
        }
        this.length = length;
    }

    public Optional<Integer> getLength() {
        if (this.isUnbounded()) {
            return Optional.empty();
        }
        return Optional.of(this.length);
    }

    public int getBoundedLength() {
        if (this.isUnbounded()) {
            throw new IllegalStateException("Cannot get size of unbounded VARCHAR.");
        }
        return this.length;
    }

    public boolean isUnbounded() {
        return this.length == Integer.MAX_VALUE;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, block.getSliceLength(position));
        if (!this.isUnbounded() && SliceUtf8.countCodePoints((Slice)slice) > this.length) {
            throw new IllegalArgumentException(String.format("Character count exceeds length limit %s: %s", this.length, Slices.sliceRepresentation(slice)));
        }
        return slice.toStringUtf8();
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getLength().map(length -> Math.min(length, 32)).orElse(32));
    }

    @Override
    public Optional<Type.Range> getRange() {
        if (this.length > 100) {
            return Optional.empty();
        }
        int codePointSize = SliceUtf8.lengthOfCodePoint((int)0x10FFFF);
        Slice max = io.airlift.slice.Slices.allocate((int)(codePointSize * this.length));
        int position = 0;
        for (int i = 0; i < this.length; ++i) {
            position += SliceUtf8.setCodePointAt((int)0x10FFFF, (Slice)max, (int)position);
        }
        return Optional.of(new Type.Range(io.airlift.slice.Slices.EMPTY_SLICE, max));
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getSliceLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getSliceLength(position));
    }

    public void writeString(BlockBuilder blockBuilder, String value) {
        this.writeSlice(blockBuilder, io.airlift.slice.Slices.utf8Slice((String)value));
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarcharType other = (VarcharType)o;
        return Objects.equals(this.length, other.length);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.length);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(Slice left, Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        int rightLength;
        int leftLength = leftBlock.getSliceLength(leftPosition);
        if (leftLength != (rightLength = rightBlock.getSliceLength(rightPosition))) {
            return false;
        }
        return leftBlock.equals(leftPosition, 0, rightBlock, rightPosition, 0, leftLength);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return block.hash(position, 0, block.getSliceLength(position));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(Slice left, Slice right) {
        return left.compareTo(right);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        int leftLength = leftBlock.getSliceLength(leftPosition);
        int rightLength = rightBlock.getSliceLength(rightPosition);
        return leftBlock.compareTo(leftPosition, 0, leftLength, rightBlock, rightPosition, 0, rightLength);
    }
}

