/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.ValidationTool;
import alluxio.cli.ValidationToolFactory;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.extensions.ExtensionsClassLoader;
import alluxio.util.io.PathUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationToolRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationToolRegistry.class);
    private static final String VALIDATION_TOOL_PATTERN = "alluxio-integration-tools-*.jar";
    private AlluxioConfiguration mConf;
    private Map<String, ValidationToolFactory> mFactories = new HashMap<String, ValidationToolFactory>();

    public ValidationToolRegistry(AlluxioConfiguration conf) {
        this.mConf = conf;
    }

    public void refresh() {
        HashMap<String, ValidationToolFactory> map = new HashMap<String, ValidationToolFactory>();
        String libDir = PathUtils.concatPath((Object)this.mConf.getString(PropertyKey.HOME), (Object)"lib");
        LOG.info("Loading validation tool jars from {}", (Object)libDir);
        ArrayList<File> files = new ArrayList<File>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(libDir, new String[0]), VALIDATION_TOOL_PATTERN);){
            for (Path entry : stream) {
                if (!entry.toFile().isFile()) continue;
                files.add(entry.toFile());
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to load validation tool libs from {}. error: {}", (Object)libDir, (Object)e.toString());
        }
        for (File jar : files) {
            try {
                URL extensionURL = jar.toURI().toURL();
                ExtensionsClassLoader extensionsClassLoader = new ExtensionsClassLoader(new URL[]{extensionURL}, ClassLoader.getSystemClassLoader());
                for (ValidationToolFactory factory : ServiceLoader.load(ValidationToolFactory.class, extensionsClassLoader)) {
                    ValidationToolFactory existingFactory = (ValidationToolFactory)map.get(factory.getType());
                    if (existingFactory != null) {
                        LOG.warn("Ignoring duplicate validation tool type '{}' found in {}. Existing factory: {}", new Object[]{factory.getType(), factory.getClass(), existingFactory.getClass()});
                    }
                    map.put(factory.getType(), factory);
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to load validation tool jar {}", (Object)jar, (Object)t);
            }
        }
        for (ValidationToolFactory factory : ServiceLoader.load(ValidationToolFactory.class, ValidationToolRegistry.class.getClassLoader())) {
            ValidationToolFactory existingFactory = (ValidationToolFactory)map.get(factory.getType());
            if (existingFactory != null) {
                LOG.warn("Ignoring duplicate validation tool type '{}' found in {}. Existing factory: {}", new Object[]{factory.getType(), factory.getClass(), existingFactory.getClass()});
            }
            map.put(factory.getType(), factory);
        }
        this.mFactories = map;
        LOG.info("Registered Factories: " + String.join((CharSequence)",", this.mFactories.keySet()));
    }

    public ValidationTool create(String type, Map<Object, Object> configMap) {
        Map<String, ValidationToolFactory> map = this.mFactories;
        ValidationToolFactory factory = map.get(type);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("ValidationToolFactory for type '%s' does not exist.", type));
        }
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(factory.getClass().getClassLoader());
            ValidationTool validationTool = factory.create(configMap);
            return validationTool;
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("Failed to create ValidationTool by factory %s", factory), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }
}

