/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.mapping;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.collect.cache.NonKeyEvictableCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.mapping.IdentifierMappingModule;
import io.trino.plugin.jdbc.mapping.MappingConfig;
import io.trino.plugin.jdbc.mapping.RemoteTableNameCacheKey;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;

public final class CachingIdentifierMapping
implements IdentifierMapping {
    private final NonKeyEvictableCache<ConnectorIdentity, Mapping> remoteSchemaNames;
    private final NonKeyEvictableCache<RemoteTableNameCacheKey, Mapping> remoteTableNames;
    private final IdentifierMapping identifierMapping;
    private final Provider<BaseJdbcClient> baseJdbcClient;

    @Inject
    public CachingIdentifierMapping(MappingConfig mappingConfig, @IdentifierMappingModule.ForCachingIdentifierMapping IdentifierMapping identifierMapping, Provider<BaseJdbcClient> baseJdbcClient) {
        CacheBuilder remoteNamesCacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(mappingConfig.getCaseInsensitiveNameMatchingCacheTtl().toMillis(), TimeUnit.MILLISECONDS);
        this.remoteSchemaNames = SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll((CacheBuilder)remoteNamesCacheBuilder);
        this.remoteTableNames = SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll((CacheBuilder)remoteNamesCacheBuilder);
        this.identifierMapping = Objects.requireNonNull(identifierMapping, "identifierMapping is null");
        this.baseJdbcClient = Objects.requireNonNull(baseJdbcClient, "baseJdbcClient is null");
    }

    public void flushCache() {
        this.remoteSchemaNames.invalidateAll();
        this.remoteTableNames.invalidateAll();
    }

    @Override
    public String fromRemoteSchemaName(String remoteSchemaName) {
        return this.identifierMapping.fromRemoteSchemaName(remoteSchemaName);
    }

    @Override
    public String fromRemoteTableName(String remoteSchemaName, String remoteTableName) {
        return this.identifierMapping.fromRemoteTableName(remoteSchemaName, remoteTableName);
    }

    @Override
    public String fromRemoteColumnName(String remoteColumnName) {
        return this.identifierMapping.fromRemoteColumnName(remoteColumnName);
    }

    @Override
    public String toRemoteSchemaName(ConnectorIdentity identity, Connection connection, String schemaName) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Verify.verify((boolean)CharMatcher.forPredicate(Character::isUpperCase).matchesNoneOf((CharSequence)schemaName), (String)"Expected schema name from internal metadata to be lowercase: %s", (Object)schemaName);
        try {
            String remoteSchema;
            Mapping mapping = (Mapping)this.remoteSchemaNames.getIfPresent((Object)identity);
            if (mapping != null && !mapping.hasRemoteObject(schemaName)) {
                mapping = null;
            }
            if (mapping == null) {
                mapping = this.createSchemaMapping(connection);
                this.remoteSchemaNames.put((Object)identity, (Object)mapping);
            }
            if ((remoteSchema = mapping.get(schemaName)) != null) {
                return remoteSchema;
            }
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to find remote schema name: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
        }
        return this.identifierMapping.toRemoteSchemaName(identity, connection, schemaName);
    }

    @Override
    public String toRemoteTableName(ConnectorIdentity identity, Connection connection, String remoteSchema, String tableName) {
        Objects.requireNonNull(remoteSchema, "remoteSchema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Verify.verify((boolean)CharMatcher.forPredicate(Character::isUpperCase).matchesNoneOf((CharSequence)tableName), (String)"Expected table name from internal metadata to be lowercase: %s", (Object)tableName);
        try {
            String remoteTable;
            RemoteTableNameCacheKey cacheKey = new RemoteTableNameCacheKey(identity, remoteSchema);
            Mapping mapping = (Mapping)this.remoteTableNames.getIfPresent((Object)cacheKey);
            if (mapping != null && !mapping.hasRemoteObject(tableName)) {
                mapping = null;
            }
            if (mapping == null) {
                mapping = this.createTableMapping(connection, remoteSchema);
                this.remoteTableNames.put((Object)cacheKey, (Object)mapping);
            }
            if ((remoteTable = mapping.get(tableName)) != null) {
                return remoteTable;
            }
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to find remote table name: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
        }
        return this.identifierMapping.toRemoteTableName(identity, connection, remoteSchema, tableName);
    }

    @Override
    public String toRemoteColumnName(Connection connection, String columnName) {
        return this.identifierMapping.toRemoteColumnName(connection, columnName);
    }

    private Mapping createSchemaMapping(Connection connection) {
        return CachingIdentifierMapping.createMapping(((BaseJdbcClient)this.baseJdbcClient.get()).listSchemas(connection), this.identifierMapping::fromRemoteSchemaName);
    }

    private Mapping createTableMapping(Connection connection, String remoteSchema) {
        return CachingIdentifierMapping.createMapping(this.getTables(connection, remoteSchema), remoteTableName -> this.identifierMapping.fromRemoteTableName(remoteSchema, (String)remoteTableName));
    }

    private static Mapping createMapping(Collection<String> remoteNames, Function<String, String> mapping) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (String remoteName : remoteNames) {
            String name = mapping.apply(remoteName);
            if (duplicates.contains(name) || map.put(name, remoteName) == null) continue;
            duplicates.add(name);
            map.remove(name);
        }
        return new Mapping(map, duplicates);
    }

    private List<String> getTables(Connection connection, String remoteSchema) {
        ImmutableList immutableList;
        block9: {
            ResultSet resultSet = ((BaseJdbcClient)this.baseJdbcClient.get()).getTables(connection, Optional.of(remoteSchema), Optional.empty());
            try {
                ImmutableList.Builder tableNames = ImmutableList.builder();
                while (resultSet.next()) {
                    tableNames.add((Object)resultSet.getString("TABLE_NAME"));
                }
                immutableList = tableNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableList;
    }

    private static final class Mapping {
        private final Map<String, String> mapping;
        private final Set<String> duplicates;

        public Mapping(Map<String, String> mapping, Set<String> duplicates) {
            this.mapping = ImmutableMap.copyOf(Objects.requireNonNull(mapping, "mapping is null"));
            this.duplicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(duplicates, "duplicates is null"));
        }

        public boolean hasRemoteObject(String remoteName) {
            return this.mapping.containsKey(remoteName) || this.duplicates.contains(remoteName);
        }

        @Nullable
        public String get(String remoteName) {
            Preconditions.checkArgument((!this.duplicates.contains(remoteName) ? 1 : 0) != 0, (String)"Ambiguous name: %s", (Object)remoteName);
            return this.mapping.get(remoteName);
        }
    }
}

