/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.fileio;

import com.google.common.io.CountingOutputStream;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.fileio.ForwardingInputFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;

public class ForwardingOutputFile
implements OutputFile {
    private final TrinoFileSystem fileSystem;
    private final TrinoOutputFile outputFile;

    public ForwardingOutputFile(TrinoFileSystem fileSystem, String path) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.outputFile = fileSystem.newOutputFile(path);
    }

    public PositionOutputStream create() {
        try {
            return new CountingPositionOutputStream(this.outputFile.create());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create file: " + this.location(), e);
        }
    }

    public PositionOutputStream createOrOverwrite() {
        try {
            return new CountingPositionOutputStream(this.outputFile.createOrOverwrite());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create file: " + this.location(), e);
        }
    }

    public String location() {
        return this.outputFile.location();
    }

    public InputFile toInputFile() {
        return new ForwardingInputFile(this.fileSystem.newInputFile(this.outputFile.location()));
    }

    private static class CountingPositionOutputStream
    extends PositionOutputStream {
        private final CountingOutputStream stream;

        private CountingPositionOutputStream(OutputStream stream) {
            this.stream = new CountingOutputStream(stream);
        }

        public long getPos() {
            return this.stream.getCount();
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void close() throws IOException {
            this.stream.close();
        }
    }
}

