/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.common.base.Verify;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

class HdfsFileIterator
implements FileIterator {
    private final String listingPath;
    private final URI listingUri;
    private final RemoteIterator<LocatedFileStatus> iterator;

    public HdfsFileIterator(String listingPath, FileSystem fs, RemoteIterator<LocatedFileStatus> iterator) {
        this.listingPath = Objects.requireNonNull(listingPath, "listingPath is null");
        this.listingUri = new Path(listingPath).makeQualified(fs.getUri(), fs.getWorkingDirectory()).toUri();
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.iterator.hasNext();
    }

    @Override
    public FileEntry next() throws IOException {
        LocatedFileStatus status = (LocatedFileStatus)this.iterator.next();
        Verify.verify((boolean)status.isFile(), (String)"iterator returned a non-file: %s", (Object)status);
        URI pathUri = status.getPath().toUri();
        URI relativeUri = this.listingUri.relativize(pathUri);
        Verify.verify((!relativeUri.equals(pathUri) ? 1 : 0) != 0, (String)"cannot relativize [%s] against [%s]", (Object)pathUri, (Object)this.listingUri);
        Object path = this.listingPath;
        if (!relativeUri.getPath().isEmpty()) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            path = (String)path + relativeUri.getPath();
        }
        return new FileEntry((String)path, status.getLen(), status.getModificationTime());
    }
}

