/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.trino.filesystem.FileIterator;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.fileio.ForwardingFileIo;
import io.trino.filesystem.hdfs.HadoopPaths;
import io.trino.filesystem.hdfs.HdfsFileIterator;
import io.trino.filesystem.hdfs.HdfsInputFile;
import io.trino.filesystem.hdfs.HdfsOutputFile;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.io.FileIO;

class HdfsFileSystem
implements TrinoFileSystem {
    private final HdfsEnvironment environment;
    private final HdfsContext context;

    public HdfsFileSystem(HdfsEnvironment environment, HdfsContext context) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    @Override
    public TrinoInputFile newInputFile(String path) {
        return new HdfsInputFile(path, null, this.environment, this.context);
    }

    @Override
    public TrinoInputFile newInputFile(String path, long length) {
        return new HdfsInputFile(path, length, this.environment, this.context);
    }

    @Override
    public TrinoOutputFile newOutputFile(String path) {
        return new HdfsOutputFile(path, this.environment, this.context);
    }

    @Override
    public void deleteFile(String path) throws IOException {
        Path file = HadoopPaths.hadoopPath(path);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, file);
        this.environment.doAs(this.context.getIdentity(), () -> {
            if (!fileSystem.delete(file, false)) {
                throw new IOException("Failed to delete file: " + file);
            }
            return null;
        });
    }

    @Override
    public void deleteDirectory(String path) throws IOException {
        Path directory = HadoopPaths.hadoopPath(path);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, directory);
        this.environment.doAs(this.context.getIdentity(), () -> {
            if (!fileSystem.delete(directory, true) && fileSystem.exists(directory)) {
                throw new IOException("Failed to delete directory: " + directory);
            }
            return null;
        });
    }

    @Override
    public void renameFile(String source, String target) throws IOException {
        Path sourcePath = HadoopPaths.hadoopPath(source);
        Path targetPath = HadoopPaths.hadoopPath(target);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, sourcePath);
        this.environment.doAs(this.context.getIdentity(), () -> {
            if (!fileSystem.rename(sourcePath, targetPath)) {
                throw new IOException(String.format("Failed to rename [%s] to [%s]", source, target));
            }
            return null;
        });
    }

    @Override
    public FileIterator listFiles(String path) throws IOException {
        Path directory = HadoopPaths.hadoopPath(path);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, directory);
        return (FileIterator)this.environment.doAs(this.context.getIdentity(), () -> {
            try {
                return new HdfsFileIterator(path, fileSystem, (RemoteIterator<LocatedFileStatus>)fileSystem.listFiles(directory, true));
            }
            catch (FileNotFoundException e) {
                return FileIterator.empty();
            }
        });
    }

    @Override
    public FileIO toFileIo() {
        return new ForwardingFileIo(this);
    }
}

