/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HadoopPaths;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class HdfsOutputFile
implements TrinoOutputFile {
    private final String path;
    private final HdfsEnvironment environment;
    private final HdfsContext context;

    public HdfsOutputFile(String path, HdfsEnvironment environment, HdfsContext context) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    @Override
    public OutputStream create() throws IOException {
        return this.create(false);
    }

    @Override
    public OutputStream createOrOverwrite() throws IOException {
        return this.create(true);
    }

    private OutputStream create(boolean overwrite) throws IOException {
        Path file = HadoopPaths.hadoopPath(this.path);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, file);
        return (OutputStream)this.environment.doAs(this.context.getIdentity(), () -> fileSystem.create(file, overwrite));
    }

    @Override
    public String location() {
        return this.path;
    }
}

