/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.expression.ExpressionMappingParser;
import io.trino.plugin.jdbc.expression.ExpressionPattern;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.spi.expression.ConnectorExpression;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;

public class GenericRewrite
implements ConnectorExpressionRule<ConnectorExpression, String> {
    private static final java.util.regex.Pattern REWRITE_TOKENS = java.util.regex.Pattern.compile("(?<![a-zA-Z0-9_$])[a-zA-Z_$][a-zA-Z0-9_$]*(?![a-zA-Z0-9_$])");
    private final ExpressionPattern expressionPattern;
    private final String rewritePattern;

    public GenericRewrite(Map<String, Set<String>> typeClasses, String expressionPattern, String rewritePattern) {
        ExpressionMappingParser parser = new ExpressionMappingParser(typeClasses);
        this.expressionPattern = parser.createExpressionPattern(expressionPattern);
        this.rewritePattern = Objects.requireNonNull(rewritePattern, "rewritePattern is null");
    }

    public Pattern<ConnectorExpression> getPattern() {
        return this.expressionPattern.getPattern();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<String> rewrite(ConnectorExpression expression, Captures captures, ConnectorExpressionRule.RewriteContext<String> context) {
        MatchContext matchContext = new MatchContext();
        this.expressionPattern.resolve(captures, matchContext);
        StringBuilder rewritten = new StringBuilder();
        Matcher matcher = REWRITE_TOKENS.matcher(this.rewritePattern);
        while (matcher.find()) {
            String replacement;
            String identifier = matcher.group(0);
            Optional<Object> capture = matchContext.getIfPresent(identifier);
            if (capture.isPresent()) {
                Object value = capture.get();
                if (value instanceof Long) {
                    replacement = Long.toString((Long)value);
                } else {
                    if (!(value instanceof ConnectorExpression)) throw new UnsupportedOperationException(String.format("Unsupported value: %s (%s)", value, value.getClass()));
                    Optional rewrittenExpression = context.defaultRewrite((ConnectorExpression)value);
                    if (rewrittenExpression.isEmpty()) {
                        return Optional.empty();
                    }
                    replacement = String.format("(%s)", rewrittenExpression.get());
                }
            } else {
                replacement = identifier;
            }
            matcher.appendReplacement(rewritten, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(rewritten);
        return Optional.of(rewritten.toString());
    }

    public String toString() {
        return String.format("%s(%s -> %s)", GenericRewrite.class.getSimpleName(), this.expressionPattern, this.rewritePattern);
    }
}

