/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.linkedin.coral.com.google.common.base.Preconditions;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class SqlNullTreatmentOperator
extends SqlSpecialOperator {
    public SqlNullTreatmentOperator(SqlKind kind) {
        super(kind.sql, kind, 20, true, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.ANY);
        Preconditions.checkArgument(kind == SqlKind.RESPECT_NULLS || kind == SqlKind.IGNORE_NULLS);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 1);
        ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.keyword(this.getName());
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 1);
        SqlCall aggCall = (SqlCall)call.operand(0);
        if (!aggCall.getOperator().isAggregator() || !((SqlAggFunction)aggCall.getOperator()).allowsNullTreatment()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.disallowsNullTreatment(aggCall.getOperator().getName()));
        }
    }
}

