/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import io.airlift.units.DataSize;
import java.util.Objects;

public class ParquetReaderOptions {
    private static final DataSize DEFAULT_MAX_READ_BLOCK_SIZE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_MERGE_DISTANCE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final boolean ignoreStatistics;
    private final DataSize maxReadBlockSize;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;
    private final boolean useColumnIndex;

    public ParquetReaderOptions() {
        this.ignoreStatistics = false;
        this.maxReadBlockSize = DEFAULT_MAX_READ_BLOCK_SIZE;
        this.maxMergeDistance = DEFAULT_MAX_MERGE_DISTANCE;
        this.maxBufferSize = DEFAULT_MAX_BUFFER_SIZE;
        this.useColumnIndex = true;
    }

    private ParquetReaderOptions(boolean ignoreStatistics, DataSize maxReadBlockSize, DataSize maxMergeDistance, DataSize maxBufferSize, boolean useColumnIndex) {
        this.ignoreStatistics = ignoreStatistics;
        this.maxReadBlockSize = Objects.requireNonNull(maxReadBlockSize, "maxReadBlockSize is null");
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.useColumnIndex = useColumnIndex;
    }

    public boolean isIgnoreStatistics() {
        return this.ignoreStatistics;
    }

    public DataSize getMaxReadBlockSize() {
        return this.maxReadBlockSize;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public boolean isUseColumnIndex() {
        return this.useColumnIndex;
    }

    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public ParquetReaderOptions withIgnoreStatistics(boolean ignoreStatistics) {
        return new ParquetReaderOptions(ignoreStatistics, this.maxReadBlockSize, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex);
    }

    public ParquetReaderOptions withMaxReadBlockSize(DataSize maxReadBlockSize) {
        return new ParquetReaderOptions(this.ignoreStatistics, maxReadBlockSize, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex);
    }

    public ParquetReaderOptions withMaxMergeDistance(DataSize maxMergeDistance) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, maxMergeDistance, this.maxBufferSize, this.useColumnIndex);
    }

    public ParquetReaderOptions withMaxBufferSize(DataSize maxBufferSize) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxMergeDistance, maxBufferSize, this.useColumnIndex);
    }

    public ParquetReaderOptions withUseColumnIndex(boolean useColumnIndex) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxMergeDistance, this.maxBufferSize, useColumnIndex);
    }
}

