/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.parquet.Field;
import io.trino.parquet.GroupField;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.PrimitiveField;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.ColumnIOUtil;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public final class ParquetTypeUtils {
    private ParquetTypeUtils() {
    }

    public static List<PrimitiveColumnIO> getColumns(MessageType fileSchema, MessageType requestedSchema) {
        return ImmutableList.copyOf((Collection)new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true).getLeaves());
    }

    public static MessageColumnIO getColumnIO(MessageType fileSchema, MessageType requestedSchema) {
        return new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true);
    }

    public static GroupColumnIO getMapKeyValueColumn(GroupColumnIO groupColumnIO) {
        while (groupColumnIO.getChildrenCount() == 1) {
            groupColumnIO = (GroupColumnIO)groupColumnIO.getChild(0);
        }
        return groupColumnIO;
    }

    public static ColumnIO getArrayElementColumn(ColumnIO columnIO) {
        while (columnIO instanceof GroupColumnIO && !columnIO.getType().isRepetition(Type.Repetition.REPEATED)) {
            columnIO = ((GroupColumnIO)columnIO).getChild(0);
        }
        if (columnIO instanceof GroupColumnIO && columnIO.getType().getLogicalTypeAnnotation() == null && ((GroupColumnIO)columnIO).getChildrenCount() == 1 && !columnIO.getName().equals("array") && !columnIO.getName().equals(columnIO.getParent().getName() + "_tuple")) {
            return ((GroupColumnIO)columnIO).getChild(0);
        }
        return columnIO;
    }

    public static Map<List<String>, ColumnDescriptor> getDescriptors(MessageType fileSchema, MessageType requestedSchema) {
        HashMap<List<String>, ColumnDescriptor> descriptorsByPath = new HashMap<List<String>, ColumnDescriptor>();
        List<PrimitiveColumnIO> columns = ParquetTypeUtils.getColumns(fileSchema, requestedSchema);
        for (String[] paths : fileSchema.getPaths()) {
            List<String> columnPath = Arrays.asList(paths);
            ParquetTypeUtils.getDescriptor(columns, columnPath).ifPresent(columnDescriptor -> descriptorsByPath.put(columnPath, (ColumnDescriptor)columnDescriptor));
        }
        return descriptorsByPath;
    }

    public static Optional<ColumnDescriptor> getDescriptor(List<PrimitiveColumnIO> columns, List<String> path) {
        Preconditions.checkArgument((path.size() >= 1 ? 1 : 0) != 0, (Object)"Parquet nested path should have at least one component");
        int index = ParquetTypeUtils.getPathIndex(columns, path);
        if (index == -1) {
            return Optional.empty();
        }
        PrimitiveColumnIO columnIO = columns.get(index);
        return Optional.of(columnIO.getColumnDescriptor());
    }

    private static int getPathIndex(List<PrimitiveColumnIO> columns, List<String> path) {
        int maxLevel = path.size();
        int index = -1;
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            ColumnIO[] fields = columns.get(columnIndex).getPath();
            if (fields.length <= maxLevel || !fields[maxLevel].getName().equalsIgnoreCase(path.get(maxLevel - 1))) continue;
            boolean match = true;
            for (int level = 0; level < maxLevel - 1; ++level) {
                if (fields[level + 1].getName().equalsIgnoreCase(path.get(level))) continue;
                match = false;
            }
            if (!match) continue;
            index = columnIndex;
        }
        return index;
    }

    public static ParquetEncoding getParquetEncoding(Encoding encoding) {
        switch (encoding) {
            case PLAIN: {
                return ParquetEncoding.PLAIN;
            }
            case RLE: {
                return ParquetEncoding.RLE;
            }
            case BYTE_STREAM_SPLIT: {
                throw new ParquetDecodingException("Unsupported Parquet encoding: " + encoding);
            }
            case BIT_PACKED: {
                return ParquetEncoding.BIT_PACKED;
            }
            case PLAIN_DICTIONARY: {
                return ParquetEncoding.PLAIN_DICTIONARY;
            }
            case DELTA_BINARY_PACKED: {
                return ParquetEncoding.DELTA_BINARY_PACKED;
            }
            case DELTA_LENGTH_BYTE_ARRAY: {
                return ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY;
            }
            case DELTA_BYTE_ARRAY: {
                return ParquetEncoding.DELTA_BYTE_ARRAY;
            }
            case RLE_DICTIONARY: {
                return ParquetEncoding.RLE_DICTIONARY;
            }
        }
        throw new ParquetDecodingException("Unsupported Parquet encoding: " + encoding);
    }

    public static Type getParquetTypeByName(String columnName, GroupType groupType) {
        if (groupType.containsField(columnName)) {
            return groupType.getType(columnName);
        }
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(columnName)) continue;
            return type;
        }
        return null;
    }

    public static ColumnIO lookupColumnByName(GroupColumnIO groupColumnIO, String columnName) {
        ColumnIO columnIO = groupColumnIO.getChild(columnName);
        if (columnIO != null) {
            return columnIO;
        }
        for (int i = 0; i < groupColumnIO.getChildrenCount(); ++i) {
            if (!groupColumnIO.getChild(i).getName().equalsIgnoreCase(columnName)) continue;
            return groupColumnIO.getChild(i);
        }
        return null;
    }

    @Nullable
    public static ColumnIO lookupColumnById(GroupColumnIO groupColumnIO, int columnId) {
        for (int i = 0; i < groupColumnIO.getChildrenCount(); ++i) {
            ColumnIO child = groupColumnIO.getChild(i);
            if (child.getType().getId().intValue() != columnId) continue;
            return child;
        }
        return null;
    }

    public static Optional<DecimalType> createDecimalType(PrimitiveField field) {
        LogicalTypeAnnotation logicalTypeAnnotation = field.getDescriptor().getPrimitiveType().getLogicalTypeAnnotation();
        if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
            return Optional.empty();
        }
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
        return Optional.of(DecimalType.createDecimalType((int)decimalLogicalType.getPrecision(), (int)decimalLogicalType.getScale()));
    }

    public static boolean isValueNull(boolean required, int definitionLevel, int maxDefinitionLevel) {
        return !required && definitionLevel == maxDefinitionLevel - 1;
    }

    public static long getShortDecimalValue(byte[] bytes) {
        return ParquetTypeUtils.getShortDecimalValue(bytes, 0, bytes.length);
    }

    public static long getShortDecimalValue(byte[] bytes, int startOffset, int length) {
        long value = 0L;
        switch (length) {
            case 8: {
                value |= (long)bytes[startOffset + 7] & 0xFFL;
            }
            case 7: {
                value |= ((long)bytes[startOffset + 6] & 0xFFL) << 8;
            }
            case 6: {
                value |= ((long)bytes[startOffset + 5] & 0xFFL) << 16;
            }
            case 5: {
                value |= ((long)bytes[startOffset + 4] & 0xFFL) << 24;
            }
            case 4: {
                value |= ((long)bytes[startOffset + 3] & 0xFFL) << 32;
            }
            case 3: {
                value |= ((long)bytes[startOffset + 2] & 0xFFL) << 40;
            }
            case 2: {
                value |= ((long)bytes[startOffset + 1] & 0xFFL) << 48;
            }
            case 1: {
                value |= ((long)bytes[startOffset] & 0xFFL) << 56;
            }
        }
        return value >>= (8 - length) * 8;
    }

    public static Optional<Field> constructField(io.trino.spi.type.Type type, ColumnIO columnIO) {
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = ColumnIOUtil.columnRepetitionLevel((ColumnIO)columnIO);
        int definitionLevel = ColumnIOUtil.columnDefinitionLevel((ColumnIO)columnIO);
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List fields = rowType.getFields();
            boolean structHasParameters = false;
            for (RowType.Field rowField : fields) {
                String name = ((String)rowField.getName().orElseThrow()).toLowerCase(Locale.ENGLISH);
                Optional<Field> field = ParquetTypeUtils.constructField(rowField.getType(), ParquetTypeUtils.lookupColumnByName(groupColumnIO, name));
                structHasParameters |= field.isPresent();
                fieldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List<Optional<Field>>)fieldsBuilder.build()));
            }
            return Optional.empty();
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn(groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() != 2) {
                return Optional.empty();
            }
            Optional<Field> keyField = ParquetTypeUtils.constructField(mapType.getKeyType(), keyValueColumnIO.getChild(0));
            Optional<Field> valueField = ParquetTypeUtils.constructField(mapType.getValueType(), keyValueColumnIO.getChild(1));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List<Optional<Field>>)ImmutableList.of(keyField, valueField)));
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            if (groupColumnIO.getChildrenCount() != 1) {
                return Optional.empty();
            }
            Optional<Field> field = ParquetTypeUtils.constructField(arrayType.getElementType(), ParquetTypeUtils.getArrayElementColumn(groupColumnIO.getChild(0)));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List<Optional<Field>>)ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        return Optional.of(new PrimitiveField(type, required, primitiveColumnIO.getColumnDescriptor(), primitiveColumnIO.getId()));
    }
}

