/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.PrimitiveType;

public class ShortDecimalColumnReader
extends PrimitiveColumnReader {
    private final DecimalType parquetDecimalType;
    private final int typeLength;

    ShortDecimalColumnReader(PrimitiveField field, DecimalType parquetDecimalType) {
        super(field);
        this.parquetDecimalType = Objects.requireNonNull(parquetDecimalType, "parquetDecimalType is null");
        this.typeLength = field.getDescriptor().getPrimitiveType().getTypeLength();
        Preconditions.checkArgument((this.typeLength <= 16 ? 1 : 0) != 0, (String)"Type length %s should be <= 16 for short decimal column %s", (int)this.typeLength, (Object)field.getDescriptor());
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type trinoType) {
        long value;
        if (!(trinoType instanceof DecimalType) && !this.isIntegerType(trinoType)) {
            throw new ParquetDecodingException(String.format("Unsupported Trino column type (%s) for Parquet column (%s)", trinoType, this.field.getDescriptor()));
        }
        if (this.field.getDescriptor().getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
            value = this.valuesReader.readInteger();
        } else if (this.field.getDescriptor().getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
            value = this.valuesReader.readLong();
        } else {
            byte[] bytes = this.valuesReader.readBytes().getBytes();
            if (this.typeLength <= 8) {
                value = ParquetTypeUtils.getShortDecimalValue(bytes);
            } else {
                int startOffset = bytes.length - 8;
                this.checkBytesFitInShortDecimal(bytes, startOffset, trinoType);
                value = ParquetTypeUtils.getShortDecimalValue(bytes, startOffset, 8);
            }
        }
        if (trinoType instanceof DecimalType) {
            DecimalType trinoDecimalType = (DecimalType)trinoType;
            if (Decimals.isShortDecimal((Type)trinoDecimalType)) {
                long rescale = Decimals.longTenToNth((int)Math.abs(trinoDecimalType.getScale() - this.parquetDecimalType.getScale()));
                long convertedValue = DecimalConversions.shortToShortCast((long)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)trinoDecimalType.getPrecision(), (long)trinoDecimalType.getScale(), (long)rescale, (long)(rescale / 2L));
                trinoType.writeLong(blockBuilder, convertedValue);
            } else if (Decimals.isLongDecimal((Type)trinoDecimalType)) {
                trinoType.writeObject(blockBuilder, (Object)DecimalConversions.shortToLongCast((long)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)trinoDecimalType.getPrecision(), (long)trinoDecimalType.getScale()));
            }
        } else {
            if (this.parquetDecimalType.getScale() != 0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", trinoType, this.field.getDescriptor()));
            }
            if (!this.isInValidNumberRange(trinoType, value)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not coerce from %s to %s: %s", this.parquetDecimalType, trinoType, value));
            }
            trinoType.writeLong(blockBuilder, value);
        }
    }

    protected boolean isIntegerType(Type type) {
        return type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT);
    }

    protected boolean isInValidNumberRange(Type type, long value) {
        if (type.equals(TinyintType.TINYINT)) {
            return -128L <= value && value <= 127L;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return -32768L <= value && value <= 32767L;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE;
        }
        if (type.equals(BigintType.BIGINT)) {
            return true;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private void checkBytesFitInShortDecimal(byte[] bytes, int endOffset, Type trinoType) {
        byte expectedValue = (byte)(bytes[endOffset] >> 7);
        for (int i = 0; i < endOffset; ++i) {
            if (bytes[i] == expectedValue) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not read fixed_len_byte_array(%d) value %s into %s", this.typeLength, new BigDecimal(new BigInteger(bytes), this.parquetDecimalType.getScale()), trinoType));
        }
    }
}

