/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.mongodb.MongoClientConfig;
import io.trino.plugin.mongodb.MongoConnector;
import io.trino.plugin.mongodb.MongoPageSinkProvider;
import io.trino.plugin.mongodb.MongoPageSourceProvider;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoSplitManager;
import io.trino.plugin.mongodb.ptf.Query;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.type.TypeManager;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

public class MongoClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(MongoConnector.class).in(Scopes.SINGLETON);
        binder.bind(MongoSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSinkProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MongoClientConfig.class);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    public static MongoSession createMongoSession(TypeManager typeManager, MongoClientConfig config) {
        MongoClientSettings.Builder options = MongoClientSettings.builder();
        options.writeConcern(config.getWriteConcern().getWriteConcern()).readPreference(config.getReadPreference().getReadPreference()).applyToConnectionPoolSettings(builder -> builder.maxConnectionIdleTime((long)config.getMaxConnectionIdleTime(), TimeUnit.MILLISECONDS).maxWaitTime((long)config.getMaxWaitTime(), TimeUnit.MILLISECONDS).minSize(config.getMinConnectionsPerHost()).maxSize(config.getConnectionsPerHost())).applyToSocketSettings(builder -> builder.connectTimeout(config.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout(config.getSocketTimeout(), TimeUnit.MILLISECONDS)).applyToSslSettings(builder -> builder.enabled(config.getSslEnabled()));
        if (config.getRequiredReplicaSetName() != null) {
            options.applyToClusterSettings(builder -> builder.requiredReplicaSetName(config.getRequiredReplicaSetName()));
        }
        if (config.getConnectionUrl().isPresent()) {
            options.applyConnectionString(new ConnectionString(config.getConnectionUrl().get()));
        } else {
            options.applyToClusterSettings(builder -> builder.hosts(config.getSeeds()));
            if (!config.getCredentials().isEmpty()) {
                options.credential(config.getCredentials().get(0));
            }
        }
        MongoClient client = MongoClients.create((MongoClientSettings)options.build());
        return new MongoSession(typeManager, client, config);
    }
}

