/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertManyOptions;
import io.airlift.slice.Slice;
import io.trino.plugin.mongodb.MongoClientConfig;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.ObjectIdType;
import io.trino.plugin.mongodb.TypeUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bson.BsonInvalidOperationException;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class MongoPageSink
implements ConnectorPageSink {
    private final MongoSession mongoSession;
    private final SchemaTableName schemaTableName;
    private final List<MongoColumnHandle> columns;
    private final String implicitPrefix;

    public MongoPageSink(MongoClientConfig config, MongoSession mongoSession, SchemaTableName schemaTableName, List<MongoColumnHandle> columns) {
        this.mongoSession = mongoSession;
        this.schemaTableName = schemaTableName;
        this.columns = columns;
        this.implicitPrefix = Objects.requireNonNull(config.getImplicitRowFieldPrefix(), "config.getImplicitRowFieldPrefix() is null");
    }

    public CompletableFuture<?> appendPage(Page page) {
        MongoCollection<Document> collection = this.mongoSession.getCollection(this.schemaTableName);
        ArrayList<Document> batch = new ArrayList<Document>(page.getPositionCount());
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Document doc = new Document();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                MongoColumnHandle column = this.columns.get(channel);
                doc.append(column.getName(), this.getObjectValue(this.columns.get(channel).getType(), page.getBlock(channel), position));
            }
            batch.add(doc);
        }
        collection.insertMany(batch, new InsertManyOptions().ordered(true));
        return NOT_BLOCKED;
    }

    private Object getObjectValue(Type type, Block block, int position) {
        if (block.isNull(position)) {
            if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
                return new ObjectId();
            }
            return null;
        }
        if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
            return new ObjectId(block.getSlice(position, 0, block.getSliceLength(position)).getBytes());
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return type.getBoolean(block, position);
        }
        if (type.equals(BigintType.BIGINT)) {
            return type.getLong(block, position);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return Math.toIntExact(type.getLong(block, position));
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return Shorts.checkedCast((long)type.getLong(block, position));
        }
        if (type.equals(TinyintType.TINYINT)) {
            return SignedBytes.checkedCast((long)type.getLong(block, position));
        }
        if (type.equals(RealType.REAL)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position))));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return type.getDouble(block, position);
        }
        if (type instanceof VarcharType) {
            return type.getSlice(block, position).toStringUtf8();
        }
        if (type instanceof CharType) {
            return Chars.padSpaces((Slice)type.getSlice(block, position), (CharType)((CharType)type)).toStringUtf8();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return new Binary(type.getSlice(block, position).getBytes());
        }
        if (type.equals(DateType.DATE)) {
            long days = type.getLong(block, position);
            return LocalDate.ofEpochDay(days);
        }
        if (type.equals(TimeType.TIME_MILLIS)) {
            long picos = type.getLong(block, position);
            return LocalTime.ofNanoOfDay(Timestamps.roundDiv((long)picos, (long)1000L));
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            long millisUtc = Math.floorDiv(type.getLong(block, position), 1000);
            Instant instant = Instant.ofEpochMilli(millisUtc);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)type.getLong(block, position));
            Instant instant = Instant.ofEpochMilli(millisUtc);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        if (type instanceof DecimalType) {
            return Decimals.readBigDecimal((DecimalType)((DecimalType)type), (Block)block, (int)position);
        }
        if (TypeUtils.isJsonType(type)) {
            String json = type.getSlice(block, position).toStringUtf8();
            try {
                return Document.parse((String)json);
            }
            catch (BsonInvalidOperationException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't convert json to MongoDB Document: " + json, (Throwable)e);
            }
        }
        if (TypeUtils.isArrayType(type)) {
            Type elementType = (Type)type.getTypeParameters().get(0);
            Block arrayBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = this.getObjectValue(elementType, arrayBlock, i);
                list.add(element);
            }
            return Collections.unmodifiableList(list);
        }
        if (TypeUtils.isMapType(type)) {
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            Block mapBlock = (Block)block.getObject(position, Block.class);
            ArrayList values = new ArrayList(mapBlock.getPositionCount() / 2);
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                HashMap<String, Object> mapValue = new HashMap<String, Object>();
                mapValue.put("key", this.getObjectValue(keyType, mapBlock, i));
                mapValue.put("value", this.getObjectValue(valueType, mapBlock, i + 1));
                values.add(mapValue);
            }
            return Collections.unmodifiableList(values);
        }
        if (TypeUtils.isRowType(type)) {
            Block rowBlock = (Block)block.getObject(position, Block.class);
            List fieldTypes = type.getTypeParameters();
            if (fieldTypes.size() != rowBlock.getPositionCount()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected row value field count does not match type field count");
            }
            if (this.isImplicitRowType(type)) {
                ArrayList<Object> rowValue = new ArrayList<Object>();
                for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                    Object element = this.getObjectValue((Type)fieldTypes.get(i), rowBlock, i);
                    rowValue.add(element);
                }
                return Collections.unmodifiableList(rowValue);
            }
            HashMap<String, Object> rowValue = new HashMap<String, Object>();
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                rowValue.put((String)((Object)((TypeSignatureParameter)type.getTypeSignature().getParameters().get(i)).getNamedTypeSignature().getName().orElse("field" + i)), this.getObjectValue((Type)fieldTypes.get(i), rowBlock, i));
            }
            return Collections.unmodifiableMap(rowValue);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }

    private boolean isImplicitRowType(Type type) {
        return type.getTypeSignature().getParameters().stream().map(TypeSignatureParameter::getNamedTypeSignature).map(NamedTypeSignature::getName).filter(Optional::isPresent).map(Optional::get).allMatch(name -> name.startsWith(this.implicitPrefix));
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
    }
}

