/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.bson.Document;

public class MongoTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<Document> filter;
    private final OptionalInt limit;

    public MongoTableHandle(SchemaTableName schemaTableName, Optional<Document> filter) {
        this(schemaTableName, filter, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty());
    }

    @JsonCreator
    public MongoTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="filter") Optional<Document> filter, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="limit") OptionalInt limit) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public Optional<Document> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public OptionalInt getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.filter, this.constraint, this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MongoTableHandle other = (MongoTableHandle)obj;
        return Objects.equals(this.schemaTableName, other.schemaTableName) && Objects.equals(this.filter, other.filter) && Objects.equals(this.constraint, other.constraint) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return this.schemaTableName.toString();
    }
}

