/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

public final class BusinessKeyGenerator {
    private static final String BUSINESS_KEY_CHARS = "ABCDEFGHIJKLMNOP";

    private BusinessKeyGenerator() {
    }

    public static String makeBusinessKey(long primary) {
        String keyPart1 = BusinessKeyGenerator.longTo8CharString(primary >> 32);
        String keyPart2 = BusinessKeyGenerator.longTo8CharString(primary);
        return keyPart1 + keyPart2;
    }

    private static String longTo8CharString(long value) {
        StringBuilder builder = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            int charIndex = (int)(value & 0xFL);
            builder.append(BUSINESS_KEY_CHARS.charAt(charIndex));
            value >>= 4;
        }
        return builder.toString();
    }
}

