/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.tpcds.distribution.DistributionUtils;
import io.trino.tpcds.random.RandomNumberStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IntValuesDistribution {
    private final ImmutableList<ImmutableList<Integer>> valuesLists;
    private final ImmutableList<ImmutableList<Integer>> weightsLists;

    public IntValuesDistribution(ImmutableList<ImmutableList<Integer>> valuesLists, ImmutableList<ImmutableList<Integer>> weightsLists) {
        this.valuesLists = valuesLists;
        this.weightsLists = weightsLists;
    }

    public static IntValuesDistribution buildIntValuesDistribution(String valuesAndWeightsFilename, int numValueFields, int numWeightFields) {
        Iterator<List<String>> iterator = DistributionUtils.getDistributionIterator(valuesAndWeightsFilename);
        ArrayList<ImmutableList.Builder> valuesBuilders = new ArrayList<ImmutableList.Builder>(numValueFields);
        for (int i = 0; i < numValueFields; ++i) {
            valuesBuilders.add(ImmutableList.builder());
        }
        ArrayList<DistributionUtils.WeightsBuilder> weightsBuilders = new ArrayList<DistributionUtils.WeightsBuilder>(numWeightFields);
        for (int i = 0; i < numWeightFields; ++i) {
            weightsBuilders.add(new DistributionUtils.WeightsBuilder());
        }
        while (iterator.hasNext()) {
            List<String> fields = iterator.next();
            Preconditions.checkState((fields.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 parts but it contains %d: %s", (int)fields.size(), fields);
            List<String> values = DistributionUtils.getListFromCommaSeparatedValues(fields.get(0));
            Preconditions.checkState((values.size() == numValueFields ? 1 : 0) != 0, (String)"Expected line to contain %d values, but it contained %d, %s", (Object)numValueFields, (Object)values.size(), (Object)values);
            for (int i = 0; i < values.size(); ++i) {
                ((ImmutableList.Builder)valuesBuilders.get(i)).add((Object)Integer.parseInt((String)values.get(i)));
            }
            List<String> weights = DistributionUtils.getListFromCommaSeparatedValues(fields.get(1));
            Preconditions.checkState((weights.size() == numWeightFields ? 1 : 0) != 0, (String)"Expected line to contain %d weights, but it contained %d, %s", (Object)numWeightFields, (Object)weights.size(), (Object)values);
            for (int i = 0; i < weights.size(); ++i) {
                ((DistributionUtils.WeightsBuilder)weightsBuilders.get(i)).computeAndAddNextWeight(Integer.parseInt(weights.get(i)));
            }
        }
        ImmutableList.Builder valuesListsBuilder = ImmutableList.builder();
        for (ImmutableList.Builder valuesBuilder : valuesBuilders) {
            valuesListsBuilder.add((Object)valuesBuilder.build());
        }
        ImmutableList valuesLists = valuesListsBuilder.build();
        ImmutableList.Builder weightsListBuilder = ImmutableList.builder();
        for (DistributionUtils.WeightsBuilder weightsBuilder : weightsBuilders) {
            weightsListBuilder.add(weightsBuilder.build());
        }
        ImmutableList weightsLists = weightsListBuilder.build();
        return new IntValuesDistribution((ImmutableList<ImmutableList<Integer>>)valuesLists, (ImmutableList<ImmutableList<Integer>>)weightsLists);
    }

    public Integer getValueForIndexModSize(long index, int valueListIndex) {
        Preconditions.checkArgument((valueListIndex < this.valuesLists.size() ? 1 : 0) != 0, (Object)("index out of range, max value index is " + (this.valuesLists.size() - 1)));
        return (Integer)DistributionUtils.getValueForIndexModSize(index, (List)this.valuesLists.get(valueListIndex));
    }

    public Integer getValueAtIndex(int valueListIndex, int valueIndex) {
        return (Integer)((ImmutableList)this.valuesLists.get(valueListIndex)).get(valueIndex);
    }

    public int pickRandomIndex(int weightListIndex, RandomNumberStream stream) {
        Preconditions.checkArgument((weightListIndex < this.weightsLists.size() ? 1 : 0) != 0, (Object)("index out of range, max weight index is " + (this.weightsLists.size() - 1)));
        return DistributionUtils.pickRandomIndex((List)this.weightsLists.get(weightListIndex), stream);
    }

    public int getSize() {
        return ((ImmutableList)this.valuesLists.get(0)).size();
    }
}

