/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.DemographicsDistributions;
import io.trino.tpcds.generator.HouseholdDemographicsGeneratorColumn;
import io.trino.tpcds.row.HouseholdDemographicsRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;

public class HouseholdDemographicsRowGenerator
extends AbstractRowGenerator {
    public HouseholdDemographicsRowGenerator() {
        super(Table.HOUSEHOLD_DEMOGRAPHICS);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long hdDemoSk;
        long nullBitMap = Nulls.createNullBitMap(Table.HOUSEHOLD_DEMOGRAPHICS, this.getRandomNumberStream(HouseholdDemographicsGeneratorColumn.HD_NULLS));
        long index = hdDemoSk = rowNumber;
        long hdIncomeBandId = index % (long)DemographicsDistributions.INCOME_BAND_DISTRIBUTION.getSize() + 1L;
        String hdBuyPotential = DemographicsDistributions.getBuyPotentialForIndexModSize(index /= (long)DemographicsDistributions.INCOME_BAND_DISTRIBUTION.getSize());
        int hdDepCount = DemographicsDistributions.getDepCountForIndexModSize(index /= (long)DemographicsDistributions.BUY_POTENTIAL_DISTRIBUTION.getSize());
        int hdVehicleCount = DemographicsDistributions.getVehicleCountForIndexModSize(index /= (long)DemographicsDistributions.DEP_COUNT_DISTRIBUTION.getSize());
        return new RowGeneratorResult(new HouseholdDemographicsRow(nullBitMap, hdDemoSk, hdIncomeBandId, hdBuyPotential, hdDepCount, hdVehicleCount));
    }
}

